/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.translator.impl;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.communication.translator.exception.TranslatorException;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

@AgentScoped
public class WorldMessageTranslator
implements IWorldChangeEventOutput {
    public static final Token COMPONENT_ID = Tokens.get((String)"WorldMessageTranslator");
    protected IWorldMessageParser parser = null;
    protected LogCategory log = null;
    protected IWorldMessageTranslator handler = null;
    private IComponentBus eventBus;
    private ComponentController<IComponent> controller;
    private IComponentControlHelper control = new ComponentControlHelper(){

        @Override
        public void startPaused() {
            this.start();
        }

        @Override
        public void start() {
            WorldMessageTranslator.this.handler.reset();
        }
    };
    private Queue<IWorldChangeEvent> worldEventQueue = new LinkedList<IWorldChangeEvent>();

    @Inject
    public WorldMessageTranslator(IWorldMessageParser parser, IWorldMessageTranslator messageHandler, IComponentBus eventBus, IAgentLogger logger) {
        this.log = logger.getCategory(this.getComponentId().getToken());
        this.parser = parser;
        NullCheck.check((Object)this.parser, (String)"parser");
        this.handler = messageHandler;
        NullCheck.check((Object)this.handler, (String)"handler");
        this.eventBus = eventBus;
        this.controller = new ComponentController<WorldMessageTranslator>(this, this.control, eventBus, (Logger)this.log, ComponentDependencyType.STARTS_AFTER, parser);
    }

    public Token getComponentId() {
        return COMPONENT_ID;
    }

    public Logger getLog() {
        return this.log;
    }

    protected IWorldChangeEvent[] processMessage(InfoMessage message) throws TranslatorException {
        return this.handler.processMessage(message);
    }

    @Override
    public synchronized IWorldChangeEvent getEvent() throws ComponentNotRunningException, ComponentPausedException {
        if (this.controller.isPaused()) {
            throw new ComponentPausedException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!this.controller.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (this.worldEventQueue.size() > 0) {
            return this.worldEventQueue.poll();
        }
        IWorldChangeEvent[] worldEvents = null;
        while (worldEvents == null || worldEvents.length == 0) {
            InfoMessage message = null;
            while (message == null) {
                message = this.parser.parse();
            }
            worldEvents = this.processMessage(message);
        }
        int i = 1;
        while (i < worldEvents.length) {
            this.worldEventQueue.add(worldEvents[i]);
            ++i;
        }
        return worldEvents[0];
    }

    public String toString() {
        if (this == null) {
            return "WorldMessageParser";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "[parser=" + this.parser + ", handler=" + this.handler + "]";
    }
}

