/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentRunner;
import cz.cuni.amis.pogamut.base.factory.IAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AgentRunner<AGENT extends IAgent, PARAMS extends IAgentParameters>
implements IAgentRunner<AGENT, PARAMS> {
    private static long ID = 0L;
    private static Object idMutex = new Object();
    protected Object mutex = new Object();
    protected IAgentFactory<AGENT, PARAMS> factory;
    protected Logger log;
    private boolean pausing = false;
    protected Level defaultLogLevel = Level.WARNING;
    protected boolean consoleLogging = true;
    protected CountDownLatch latch;
    protected List<AGENT> agents = null;
    protected boolean killed = false;
    protected boolean main = false;
    protected boolean killingAgents = false;
    protected Object killingAgentsMutex = new Object();
    protected FlagListener<IAgentState> listener = new FlagListener<IAgentState>(){

        public void flagChanged(IAgentState changedValue) {
            if (changedValue instanceof IAgentStateFailed) {
                AgentRunner.this.killAgents(AgentRunner.this.agents);
            } else if (changedValue instanceof IAgentStateDown) {
                AgentRunner.this.latch.countDown();
            }
        }
    };

    public AgentRunner(IAgentFactory<AGENT, PARAMS> factory) {
        this.factory = factory;
        NullCheck.check(this.factory, (String)"factory");
    }

    public Logger getLog() {
        return this.log;
    }

    public AgentRunner<AGENT, PARAMS> setLog(Logger log) {
        this.log = log;
        return this;
    }

    @Override
    public synchronized AGENT startAgent() throws PogamutException {
        List agent = this.main ? this.startAgentWithParamsMain(false, new IAgentParameters[]{this.newDefaultAgentParameters()}) : this.startAgentWithParams(false, new IAgentParameters[]{this.newDefaultAgentParameters()});
        return (AGENT)((IAgent)agent.get(0));
    }

    @Override
    public synchronized List<AGENT> startAgents(int count) throws PogamutException {
        IAgentParameters[] params = new IAgentParameters[count];
        int i = 0;
        while (i < params.length) {
            params[i] = this.newDefaultAgentParameters();
            ++i;
        }
        if (this.main) {
            return this.startAgentWithParamsMain(false, params);
        }
        return this.startAgentWithParams(false, params);
    }

    @Override
    public synchronized List<AGENT> startAgents(PARAMS ... agentParameters) throws PogamutException {
        if (this.main) {
            return this.startAgentWithParamsMain(true, (IAgentParameters[])agentParameters);
        }
        return this.startAgentWithParams(true, (IAgentParameters[])agentParameters);
    }

    @Override
    public boolean isPausing() {
        return this.pausing;
    }

    @Override
    public synchronized AgentRunner<AGENT, PARAMS> setPausing(boolean state) {
        this.pausing = state;
        return this;
    }

    @Override
    public boolean isMain() {
        return this.main;
    }

    @Override
    public synchronized AgentRunner<AGENT, PARAMS> setMain(boolean state) {
        this.main = state;
        return this;
    }

    public AgentRunner<AGENT, PARAMS> setLogLevel(Level logLevel) {
        this.defaultLogLevel = logLevel;
        return this;
    }

    public AgentRunner<AGENT, PARAMS> setConsoleLogging(boolean enabled) {
        this.consoleLogging = enabled;
        return this;
    }

    protected List<AGENT> startAgentWithParams(boolean fillDefaults, PARAMS ... params) {
        if (params == null || params.length == 0) {
            return new ArrayList(0);
        }
        ArrayList<AGENT> result = new ArrayList<AGENT>(params.length);
        boolean pausingBehavior = this.isPausing();
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preInitHook()...");
            }
            this.preInitHook();
            int i = 0;
            while (i < params.length) {
                if (fillDefaults) {
                    params[i].assignDefaults(this.newDefaultAgentParameters());
                }
                AGENT agent = this.createAgentWithParams(params[i]);
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling preStartHook()...");
                }
                this.preStartHook(agent);
                this.startAgent(agent);
                if (pausingBehavior) {
                    agent.pause();
                }
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling postStartHook()...");
                }
                this.postStartHook(agent);
                result.add(agent);
                ++i;
            }
            if (pausingBehavior) {
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling preResumeHook()...");
                }
                this.preResumeHook(result);
                for (IAgent agent : result) {
                    agent.resume();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling postStartedHookCalled()...");
            }
            this.postStartedHook(result);
        }
        catch (PogamutException e) {
            this.killAgents(result);
            throw e;
        }
        catch (Exception e) {
            this.killAgents(result);
            throw new PogamutException("Agent's can't be started: " + e.getMessage(), (Throwable)e, (Object)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<AGENT> startAgentWithParamsMain(boolean fillDefaults, PARAMS ... params) {
        if (params == null || params.length == 0) {
            return new ArrayList(0);
        }
        this.latch = new CountDownLatch(params.length);
        this.agents = new ArrayList<AGENT>(params.length);
        this.killed = false;
        boolean pausingBehavior = this.isPausing();
        try {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calling preInitHook()...");
            }
            this.preInitHook();
            int i = 0;
            while (i < params.length) {
                if (this.killed) break;
                if (fillDefaults) {
                    params[i].assignDefaults(this.newDefaultAgentParameters());
                }
                AGENT agent = this.createAgentWithParams(params[i]);
                if (this.killed) break;
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling preStartHook()...");
                }
                this.preStartHook(agent);
                if (this.killed) break;
                this.startAgent(agent);
                if (this.killed) {
                    this.killAgent(agent);
                    break;
                }
                if (pausingBehavior) {
                    agent.pause();
                }
                if (this.killed) {
                    this.killAgent(agent);
                    break;
                }
                if (this.log != null && this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Calling postStartHook()...");
                }
                this.postStartHook(agent);
                if (this.killed) {
                    this.killAgent(agent);
                    break;
                }
                Object object = this.mutex;
                synchronized (object) {
                    if (this.killed) {
                        this.killAgent(agent);
                        break;
                    }
                    this.agents.add(agent);
                }
                ++i;
            }
            if (!this.killed) {
                if (pausingBehavior) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Calling preResumeHook()...");
                    }
                    this.preResumeHook(this.agents);
                    for (IAgent agent : this.agents) {
                        agent.resume();
                    }
                }
                if (!this.killed) {
                    if (this.log != null && this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Calling postStartedHookCalled()...");
                    }
                    this.postStartedHook(this.agents);
                }
                if (!this.killed) {
                    try {
                        this.latch.await();
                    }
                    catch (InterruptedException e) {
                        throw new PogamutInterruptedException("Interrupted while waiting for the agents to finish their execution.", (Throwable)e, (Object)this);
                    }
                }
            }
            if (this.killed) {
                throw new PogamutException("Could not execute all agents due to an exception, check logs of respective agents.", (Object)this);
            }
            List<AGENT> list = this.agents;
            return list;
        }
        catch (PogamutException e) {
            this.killAgents(this.agents);
            throw e;
        }
        catch (Exception e) {
            this.killAgents(this.agents);
            throw new PogamutException("Agents can't be started: " + e.getMessage(), (Throwable)e, (Object)this);
        }
        finally {
            Pogamut.getPlatform().close();
        }
    }

    protected abstract IAgentParameters newDefaultAgentParameters();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IAgentId newAgentId(String name) {
        if (name == null) {
            name = "Unnamed";
        }
        Object object = idMutex;
        synchronized (object) {
            return new AgentId(String.valueOf(name) + ++ID);
        }
    }

    protected void fillInDefaults(PARAMS params) {
        params.assignDefaults(this.newDefaultAgentParameters());
    }

    protected void fillInDefaults(PARAMS[] paramsArray) {
        PARAMS[] PARAMSArray = paramsArray;
        int n = paramsArray.length;
        int n2 = 0;
        while (n2 < n) {
            PARAMS params = PARAMSArray[n2];
            params.assignDefaults(this.newDefaultAgentParameters());
            ++n2;
        }
    }

    protected AGENT createAgentWithParams(PARAMS params) {
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Instantiating agent with id '" + params.getAgentId().getToken() + "'");
        }
        AGENT agent = this.factory.newAgent(params);
        if (this.consoleLogging) {
            agent.getLogger().addDefaultConsoleHandler();
        }
        if (this.defaultLogLevel != null) {
            agent.getLogger().setLevel(this.defaultLogLevel);
        }
        return agent;
    }

    protected void startAgent(AGENT agent) {
        if (this.main) {
            agent.getState().addListener(this.listener);
        }
        if (this.log != null && this.log.isLoggable(Level.INFO)) {
            this.log.info("Starting agent with id '" + agent.getComponentId().getToken() + "'");
        }
        agent.start();
    }

    /*
     * Exception decompiling
     */
    protected void killAgents(List<AGENT> agents) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killAgent(AGENT agent) {
        if (agent == null) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.main) {
                agent.getState().removeListener(this.listener);
            }
            if (!(agent.getState().getFlag() instanceof IAgentStateDown)) {
                if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Killing agent with id '" + agent.getComponentId().getToken() + "'");
                }
                try {
                    agent.kill();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected void preInitHook() throws PogamutException {
    }

    protected void preStartHook(AGENT agent) throws PogamutException {
    }

    protected void postStartHook(AGENT agent) throws PogamutException {
    }

    protected void preResumeHook(List<AGENT> agents) {
    }

    protected void postStartedHook(List<AGENT> agents) {
    }
}

