/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.ComponentBusEvents;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResetEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartingPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.controller.AbstractComponentControllerBase;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.IComponentController;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentController<COMPONENT extends IComponent>
extends AbstractComponentControllerBase<COMPONENT>
implements IComponentController<COMPONENT> {
    private Object ctrlMutex = new Object();
    private ComponentDependencies dependencies;
    private Map<IToken, ComponentState> dependencyState = new HashMap<IToken, ComponentState>();
    private Map<ComponentState, Integer> stateCount = new HashMap<ComponentState, Integer>();
    private IFatalErrorEvent lastFatalError = null;
    private IComponentEventListener<IStartingEvent> startingListener = new IComponentEventListener<IStartingEvent>(){

        public void notify(IStartingEvent event) {
            ComponentController.this.startingEvent(event, false);
        }
    };
    private IComponentEventListener<IStartingPausedEvent> startingPausedListener = new IComponentEventListener<IStartingPausedEvent>(){

        public void notify(IStartingPausedEvent event) {
            ComponentController.this.startingPausedEvent(event);
        }
    };
    private IComponentEventListener<IStartedEvent> startedListener = new IComponentEventListener<IStartedEvent>(){

        public void notify(IStartedEvent event) {
            ComponentController.this.startedEvent(event);
        }
    };
    private IComponentEventListener<IPausingEvent> pausingListener = new IComponentEventListener<IPausingEvent>(){

        public void notify(IPausingEvent event) {
            ComponentController.this.pausingEvent(event, false);
        }
    };
    private IComponentEventListener<IPausedEvent> pausedListener = new IComponentEventListener<IPausedEvent>(){

        public void notify(IPausedEvent event) {
            ComponentController.this.pausedEvent(event);
        }
    };
    private IComponentEventListener<IResumingEvent> resumingListener = new IComponentEventListener<IResumingEvent>(){

        public void notify(IResumingEvent event) {
            ComponentController.this.resumingEvent(event, false);
        }
    };
    private IComponentEventListener<IResumedEvent> resumedListener = new IComponentEventListener<IResumedEvent>(){

        public void notify(IResumedEvent event) {
            ComponentController.this.resumedEvent(event);
        }
    };
    private IComponentEventListener<IStoppingEvent> stoppingListener = new IComponentEventListener<IStoppingEvent>(){

        public void notify(IStoppingEvent event) {
            ComponentController.this.stoppingEvent(event, false);
        }
    };
    private IComponentEventListener<IStoppedEvent> stoppedListener = new IComponentEventListener<IStoppedEvent>(){

        public void notify(IStoppedEvent event) {
            ComponentController.this.stoppedEvent(event);
        }
    };
    private IComponentEventListener<IFatalErrorEvent> fatalErrorListener = new IComponentEventListener<IFatalErrorEvent>(){

        public void notify(IFatalErrorEvent event) {
            ComponentController.this.fatalErrorEvent(event);
        }
    };
    private IComponentEventListener<IResetEvent> resetEventListener = new IComponentEventListener<IResetEvent>(){

        public void notify(IResetEvent event) {
            ComponentController.this.resetEvent(event);
        }
    };
    private IComponentBus bus;
    private ComponentBusEvents componentEvents;

    public ComponentController(COMPONENT component, IComponentControlHelper componentControlHelper, ILifecycleBus bus, Logger log, ComponentDependencyType dependencyType, Object ... dependencies) {
        this(component, componentControlHelper, bus, log, new ComponentDependencies(dependencyType, dependencies));
    }

    public ComponentController(COMPONENT component, IComponentControlHelper componentControlHelper, ILifecycleBus bus, Logger log, ComponentDependencies dependencies) {
        this(component, componentControlHelper, (IComponentBus)bus, log, dependencies);
    }

    public ComponentController(COMPONENT component, IComponentControlHelper componentControlHelper, IComponentBus bus, Logger log, ComponentDependencyType dependencyType, Object ... dependencies) {
        this(component, componentControlHelper, bus, log, new ComponentDependencies(dependencyType, dependencies));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public ComponentController(COMPONENT component, IComponentControlHelper componentControlHelper, IComponentBus bus, Logger log, ComponentDependencies dependencies) {
        super((IToken)Tokens.get((String)(component.getComponentId().getToken() + "-controller")), component, componentControlHelper, log);
        this.bus = bus;
        NullCheck.check((Object)this.bus, (String)"bus");
        this.dependencies = dependencies;
        NullCheck.check((Object)this.dependencies, (String)"dependencies");
        this.bus.register((IComponent)component);
        this.bus.register(this);
        this.componentEvents = new ComponentBusEvents(bus, this.component, log);
        for (ComponentState componentState : ComponentState.values()) {
            this.stateCount.put(componentState, 0);
        }
        this.stateCount.put(ComponentState.INSTANTIATED, dependencies.getCount());
        for (ComponentState componentState : dependencies.getDependencies()) {
            this.dependencyState.put((IToken)componentState, ComponentState.INSTANTIATED);
        }
        this.bus.addEventListener(IFatalErrorEvent.class, this.fatalErrorListener);
        this.bus.addEventListener(IResetEvent.class, this.resetEventListener);
        Object object = this.ctrlMutex;
        synchronized (object) {
            IToken dependency;
            void var9_14;
            IToken[] arr$ = dependencies.getDependencies();
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_14 < len$) {
                dependency = arr$[var9_14];
                this.bus.addEventListener(IStartingEvent.class, dependency, this.startingListener);
                this.bus.addEventListener(IStartingPausedEvent.class, dependency, this.startingPausedListener);
                this.bus.addEventListener(IStartedEvent.class, dependency, this.startedListener);
                this.bus.addEventListener(IStoppingEvent.class, dependency, this.stoppingListener);
                this.bus.addEventListener(IStoppedEvent.class, dependency, this.stoppedListener);
                this.bus.addEventListener(IPausingEvent.class, dependency, this.pausingListener);
                this.bus.addEventListener(IPausedEvent.class, dependency, this.pausedListener);
                this.bus.addEventListener(IResumingEvent.class, dependency, this.resumingListener);
                this.bus.addEventListener(IResumedEvent.class, dependency, this.resumedListener);
                ++var9_14;
            }
            if (bus instanceof ILifecycleBus) {
                void var9_16;
                arr$ = dependencies.getDependencies();
                len$ = arr$.length;
                boolean bl2 = false;
                while (var9_16 < len$) {
                    dependency = arr$[var9_16];
                    this.setDependencyState(dependency, (ComponentState)((Object)((ILifecycleBus)bus).getComponentState(dependency).getFlag()));
                    ++var9_16;
                }
                if (this.inState(ComponentState.INSTANTIATED, ComponentState.RESETED)) {
                    if (dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
                        if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) == dependencies.getCount()) {
                            this.start(false);
                        } else if (this.getStateCount(ComponentState.STARTING, ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.RESUMING, ComponentState.RUNNING) == dependencies.getCount()) {
                            this.startPaused(false);
                        }
                    } else if (this.getStateCount(ComponentState.RUNNING) == dependencies.getCount()) {
                        this.start(false);
                    } else if (this.getStateCount(ComponentState.PAUSED, ComponentState.RUNNING) == dependencies.getCount()) {
                        this.startPaused(false);
                    }
                }
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("In state " + this.componentState.getFlag() + ".");
        }
    }

    @Override
    public void setBroadcastingEvents(boolean broadcastingEvents) {
        super.setBroadcastingEvents(broadcastingEvents);
        this.componentEvents.setBroadcasting(broadcastingEvents);
    }

    @Override
    public IFatalErrorEvent getFatalError() {
        return this.lastFatalError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualStart(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.KILLED, ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Start requested, but the component is in state " + this.componentState.getFlag() + ", unsupported.");
                }
            } else {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Start requested.");
                }
                if (this.inState(ComponentState.KILLED)) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Component is in state " + (Object)((Object)ComponentState.KILLED) + ", resetting.");
                    }
                    this.reset();
                }
                this.start(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualStartPaused(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.KILLED, ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Start-paused requested, but the component is in state " + this.componentState.getFlag() + ", unsupported.");
                }
            } else {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Start-paused requested.");
                }
                if (this.inState(ComponentState.KILLED)) {
                    if (this.log.isLoggable(Level.WARNING)) {
                        this.log.warning("Component is in state " + (Object)((Object)ComponentState.KILLED) + ", resetting.");
                    }
                    this.reset();
                }
                this.startPaused(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualStop(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.inState(ComponentState.RUNNING, ComponentState.PAUSED)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Stop requested, reason: " + reason);
                }
                this.stop(true);
            } else if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Stop requested, but the component is in state " + this.componentState.getFlag() + ", unsupported.");
            }
        }
    }

    @Override
    public void manualKill(String reason) {
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log.severe("Kill requested, reason: " + reason);
        }
        this.kill(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualPause(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.inState(ComponentState.RUNNING)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(this.id(this.component) + " pause requested, reason: " + reason);
                }
                this.pause(true);
            } else if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning(this.id(this.component) + " pause requested, but the component is in state " + this.componentState.getFlag() + ", unsupported.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualResume(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.inState(ComponentState.PAUSED)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(this.id(this.component) + " resume requested, reason: " + reason);
                }
                this.resume(true);
            } else if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning(this.id(this.component) + " resume requested, but the component is in state " + this.componentState.getFlag() + ", unsupported.");
            }
        }
    }

    @Override
    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fatalError(String message, Throwable e) {
        try {
            if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
                return;
            }
        }
        catch (Exception e0) {
            // empty catch block
        }
        Object e0 = this.ctrlMutex;
        synchronized (e0) {
            try {
                if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
                    return;
                }
            }
            catch (Exception e02) {
                // empty catch block
            }
            try {
                this.setState(ComponentState.KILLING);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        try {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe("Fatal error in " + this.id(this.component) + ": " + message);
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            this.control.kill();
        }
        catch (Exception e3) {
            // empty catch block
        }
        try {
            this.lastFatalError = new FatalErrorEvent<IComponent>(this.component, message, e);
            this.bus.event(this.lastFatalError);
        }
        catch (Exception e5) {
            // empty catch block
        }
        try {
            this.setState(ComponentState.KILLED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isDependent(IToken token) {
        return this.dependencies.isDependency(token);
    }

    @Override
    public boolean isDependent(IComponent component) {
        return this.dependencies.isDependency(component);
    }

    private int getStateCount(ComponentState ... states) {
        int total = 0;
        for (ComponentState state : states) {
            total += this.stateCount.get((Object)state).intValue();
        }
        if (total > this.dependencies.getCount()) {
            throw new IllegalStateException("Sum of ints from stateCount can't be greater than number of dependencies.");
        }
        return total;
    }

    private ComponentState getDependencyState(IComponent dependency) {
        return this.getDependencyState(dependency.getComponentId());
    }

    private ComponentState getDependencyState(IToken componentId) {
        return this.dependencyState.get(componentId);
    }

    private boolean setDependencyState(IComponent dependency, ComponentState newState) {
        return this.setDependencyState(dependency.getComponentId(), newState);
    }

    private boolean setDependencyState(IToken dependency, ComponentState newState) {
        ComponentState oldState = this.dependencyState.get(dependency);
        if (oldState == newState) {
            return false;
        }
        int count = this.stateCount.get((Object)oldState);
        if (count <= 0) {
            throw new IllegalStateException("There should not be a dependency in state " + (Object)((Object)oldState) + ", but still...");
        }
        this.stateCount.put(oldState, count - 1);
        this.dependencyState.put(dependency, newState);
        count = this.stateCount.get((Object)newState);
        this.stateCount.put(newState, count + 1);
        if (count + 1 > this.dependencies.getCount()) {
            throw new IllegalStateException("There are too many dependencies in state " + (Object)((Object)newState) + ", more than is possible...");
        }
        return true;
    }

    private boolean dependencyInState(IComponent dependency, ComponentState ... states) {
        return this.dependencyInState(dependency.getComponentId(), states);
    }

    private boolean dependencyInState(IToken componentId, ComponentState ... states) {
        ComponentState state = this.dependencyState.get(componentId);
        if (state == null) {
            return false;
        }
        for (ComponentState s : states) {
            if (state != s) continue;
            return true;
        }
        return false;
    }

    private boolean dependencyNotInState(IComponent dependency, ComponentState ... states) {
        return this.dependencyInState(dependency.getComponentId(), new ComponentState[0]);
    }

    private boolean dependencyNotInState(IToken componentId, ComponentState ... states) {
        ComponentState state = this.dependencyState.get(componentId);
        if (state == null) {
            return true;
        }
        for (ComponentState s : states) {
            if (state != s) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " starting event.");
                }
            } else if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " starting event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STARTING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'starting event' twice, ignoring.");
                }
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                throw new ComponentCantStartException(this.id((IComponent)eventComponent) + " is broadcasting 'starting event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STARTING)) {
                if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED) == 0) {
                    this.startingChangedByStartingEvent(event);
                } else {
                    this.startingChangedByStartingEventButOneComponentIsStartingPausedOrPausingOrPaused(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startedEvent(IStartedEvent event) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " started event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'started event' while running, ignoring.");
                }
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'started event' but did not broadcast 'starting event' before, ill behavior, simulating the event.");
                }
                this.startingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.STARTING)) {
                throw new ComponentCantStartException(this.id((IComponent)eventComponent) + " is broadcasting 'started event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.runningChangedByStartedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startingPausedEvent(IComponentEvent event) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STARTING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'starting event' twice, ignoring.");
                }
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                throw new ComponentCantStartException(this.id((IComponent)eventComponent) + " is broadcasting 'starting event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STARTING_PAUSED)) {
                this.startingChangedByStartingPausedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " pausing event.");
                }
            } else if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " pausing event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'pausing event' twice, ignoring.");
                }
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                throw new ComponentCantPauseException(this.id((IComponent)eventComponent) + " is broadcasting 'pausing event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.PAUSING)) {
                this.pausingChangedByPausingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausedEvent(IPausedEvent event) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " paused event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'paused event' twice, ignoring.");
                }
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'paused event' but did not broadcast 'pausing event' before, ill behavior, simulating the event.");
                }
                this.pausingEvent(event, true);
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STARTING_PAUSED)) {
                if (this.setDependencyState((IComponent)eventComponent, ComponentState.PAUSED)) {
                    this.pausedChangedByPausedEventAfterStartingPaused(event);
                }
            } else if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSING)) {
                if (this.setDependencyState((IComponent)eventComponent, ComponentState.PAUSED)) {
                    this.pausedChangedByPausedEvent(event);
                }
            } else {
                throw new ComponentCantPauseException(this.id((IComponent)eventComponent) + " is broadcasting 'paused event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " resuming event.");
                }
            } else if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " resuming event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RESUMING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'resuming event' twice, ignoring.");
                }
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED)) {
                throw new ComponentCantResumeException(this.id((IComponent)eventComponent) + " is broadcasting 'resuming event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.RESUMING)) {
                this.resumingChangedByResumingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumedEvent(IResumedEvent event) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " resumed event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'resumed event' while running, ignoring.");
                }
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'resumed event' but did not broadcast 'resuming event' before, ill behavior, simulating the event.");
                }
                this.resumingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.RESUMING)) {
                throw new ComponentCantResumeException(this.id((IComponent)eventComponent) + " is broadcasting 'resumed event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.runningChangedByResumedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stoppingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " stopping event.");
                }
            } else if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " stopping event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STOPPING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'stopping event' twice, ignoring.");
                }
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
                throw new ComponentCantStopException(this.id((IComponent)eventComponent) + " is broadcasting 'stopping event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STOPPING)) {
                this.stoppingChangedByStoppingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stoppedEvent(IStoppedEvent event) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            NullCheck.check((Object)event, (String)"event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " stopped event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STOPPED)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'stopped event' twice, ignoring.");
                }
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(this.id((IComponent)eventComponent) + " is broadcasting 'stopped event' but did not broadcast 'stopping event' before, ill behavior, simulating the event.");
                }
                this.stoppingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.STOPPING)) {
                throw new ComponentCantStopException(this.id((IComponent)eventComponent) + " is broadcasting 'stopped event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STOPPED)) {
                this.stoppedChangedByStoppedEvent(event);
            }
        }
    }

    private void fatalErrorEvent(IFatalErrorEvent event) {
        if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
            return;
        }
        if (event.getSource() == this.component) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Fatal error received from the controlled component, discarding.");
            }
            return;
        }
        this.lastFatalError = event;
        if (this.log.isLoggable(Level.SEVERE)) {
            this.log.severe("Received fatal error from " + this.id((IComponent)event.getSource()) + ".");
        }
        this.componentFatalError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEvent(IResetEvent event) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Received reset event.");
            }
            this.componentReset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startingChangedByStartingEvent(IComponentEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_AFTER) {
            return;
        }
        if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (!this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) throw new ComponentCantStartException("All dependencies are starting/resuming/has started, but can't start the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, this.component);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All dependencies are starting/resuming/has started, starting the component.");
            }
            this.start(false);
            return;
        } else {
            if (this.getStateCount(ComponentState.STARTING, ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.RESUMING, ComponentState.RUNNING) != this.dependencies.getCount()) return;
            if (!this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) throw new ComponentCantStartException("All dependencies are starting/resuming/has started but there are some which are in STARTING_PAUSED/PAUSING/PAUSED state, but can't starting-paused the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, this.component);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All dependencies are starting/resuming/has started but there are some which are in STARTING_PAUSED/PAUSING/PAUSED state, starting-paused the component.");
            }
            this.startPaused(false);
        }
    }

    private void startingChangedByStartingEventButOneComponentIsStartingPausedOrPausingOrPaused(IComponentEvent event) {
        this.startingChangedByStartingEvent(event);
    }

    private void startingChangedByStartingPausedEvent(IComponentEvent event) {
        this.startingChangedByStartingEvent(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runningChangedByStartedEvent(IStartedEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
            return;
        }
        if (this.getStateCount(ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (!this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) throw new ComponentCantStartException("All dependencies has started/resumed, but can't start the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, this.component);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All dependencies has started/resumed, starting the component.");
            }
            this.start(false);
            return;
        } else {
            if (this.getStateCount(ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED) != this.dependencies.getCount()) return;
            if (!this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) throw new ComponentCantStartException("All dependencies has started/resumed, but there are some that is pausing/paused, but can't starting-paused the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, this.component);
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All dependencies has started/resumed but there are some that is pausing/paused, starting-paused the component.");
            }
            this.startPaused(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runningChangedByResumedEvent(IResumedEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
            return;
        }
        if (this.getStateCount(ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("All dependencies has started/resumed, starting the component.");
                }
                this.start(false);
                return;
            } else {
                if (!this.inState(ComponentState.PAUSED)) throw new ComponentCantStartException("All dependencies has started/resumed, but can't start/resume the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, this.component);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("All dependencies has started/resumed, resuming the component.");
                }
                this.resume(false);
            }
            return;
        } else {
            if (this.getStateCount(ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED) != this.dependencies.getCount() || !this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) return;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All dependencies has started/resumed but some of them are pausing/paused, starting-paused the component.");
            }
            this.start(false);
        }
    }

    private void pausingChangedByPausingEvent(IComponentEvent event) {
        if (this.inState(ComponentState.RUNNING)) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " is pausing, pausing the component.");
            }
            this.pause(false);
        }
    }

    private void pausedChangedByPausedEvent(IPausedEvent event) {
        if (this.inState(ComponentState.RUNNING)) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " has paused, pausing the component.");
            }
            this.pause(false);
        }
    }

    private void pausedChangedByPausedEventAfterStartingPaused(IPausedEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
            return;
        }
        if (this.getStateCount(ComponentState.RUNNING, ComponentState.PAUSED) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("All dependencies has started/started into paused/are paused, starting-paused the component.");
                }
                this.startPaused(false);
            } else {
                throw new ComponentCantStartException("All dependencies has started/started into paused/are paused, but can't starting-paused the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, this.component);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resumingChangedByResumingEvent(IComponentEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_AFTER) {
            return;
        }
        if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("All dependencies has started/resumed, starting the component.");
                }
                this.start(false);
                return;
            } else {
                if (!this.inState(ComponentState.PAUSED)) throw new ComponentCantResumeException("All dependencies are starting/resuming/has started, but can't resume the component, it's in an ill state " + this.componentState.getFlag() + ".", this.log, (Object)this.component);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("All dependencies are starting/resuming/has started, resuming the component.");
                }
                this.resume(false);
            }
            return;
        } else {
            if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING, ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED) != this.dependencies.getCount() || !this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) return;
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All dependencies are starting/resuming/has started but there are some which are in STARTING_PAUSED/PAUSING/PAUSED state, starting-paused the component.");
            }
            this.startPaused(false);
        }
    }

    private void stoppingChangedByStoppingEvent(IComponentEvent event) {
        if (this.inState(ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " is stopping, stopping the component.");
            }
            this.stop(false);
        }
    }

    private void stoppedChangedByStoppedEvent(IStoppedEvent event) {
        if (this.inState(ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " is stopping, stopping the component.");
            }
            this.stop(false);
        }
    }

    private void componentFatalError() {
        switch ((ComponentState)((Object)this.componentState.getFlag())) {
            case INSTANTIATED: {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component is in instantiated state, won't call kill().");
                }
                return;
            }
            case RESETED: {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component is resetted, won't call kill().");
                }
                return;
            }
            case KILLED: {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component has been already killed, won't call kill().");
                }
                return;
            }
        }
        this.kill(false);
    }

    private void componentReset() {
        switch ((ComponentState)((Object)this.componentState.getFlag())) {
            case INSTANTIATED: {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component is in instantiated state, won't call reset().");
                }
                return;
            }
            case RESETED: {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning("Component is resetted, won't call reset().");
                }
                return;
            }
            case KILLED: {
                this.reset();
                return;
            }
        }
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("Reset event received but the component has not been killed! Current state is " + this.componentState.getFlag() + ", killing the component first!");
        }
        this.kill(false);
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning("And than, resetting it!");
        }
        this.reset();
    }

    private void start(boolean manual) {
        this.setState(ComponentState.STARTING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".preStart().");
        }
        this.control.preStart();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " starting event (transactional).");
        }
        this.componentEvents.startingTransactional();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.id(this.component) + " starting event (transactional) sent.");
        }
        if (!manual) {
            if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) != this.dependencies.getCount()) {
                    if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED) == this.dependencies.getCount()) {
                        this.fatalError("Some components is pausing / has paused after starting-event of " + this.id(this.component) + ", unsupported state!");
                        return;
                    }
                    this.fatalError("Some components has stopped after starting-event of " + this.id(this.component) + ", unsupported state!");
                    return;
                }
            } else if (this.getStateCount(ComponentState.RUNNING) != this.dependencies.getCount()) {
                if (this.getStateCount(ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED) == this.dependencies.getCount()) {
                    this.fatalError("Some components is pausing / has paused after starting-event of " + this.id(this.component) + ", unsupported state!");
                    return;
                }
                this.fatalError("Some components has stopped after starting-event of " + this.id(this.component) + ", unsupported state!");
                return;
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".start().");
        }
        this.control.start();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + ".start()ed.");
        }
        this.setState(ComponentState.RUNNING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " started event (transactional).");
        }
        this.componentEvents.startedTransactional();
    }

    private void startPaused(boolean manual) {
        this.setState(ComponentState.STARTING_PAUSED);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".preStartPaused().");
        }
        this.control.preStartPaused();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " starting-paused event (transactional).");
        }
        this.componentEvents.startingPausedTransactional();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.id(this.component) + " starting-paused event (transactional) sent.");
        }
        if (!manual) {
            if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) == this.dependencies.getCount()) {
                    this.fatalError("Some components is resuming / has resumed after starting-paused-event of " + this.id(this.component) + ", unsupported state!");
                    return;
                }
                if (this.getStateCount(ComponentState.STARTING, ComponentState.STARTING_PAUSED, ComponentState.RESUMING, ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED) != this.dependencies.getCount()) {
                    this.fatalError("Some components has stopped after starting-paused-event of " + this.id(this.component) + ", unsupported state!");
                    return;
                }
            } else {
                if (this.getStateCount(ComponentState.RUNNING) == this.dependencies.getCount()) {
                    this.fatalError("Some components is resuming / has resumed after starting-paused-event of " + this.id(this.component) + ", unsupported state!");
                    return;
                }
                if (this.getStateCount(ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED) != this.dependencies.getCount()) {
                    this.fatalError("Some components has stopped after starting-paused-event of " + this.id(this.component) + ", unsupported state!");
                    return;
                }
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".startPaused().");
        }
        this.control.startPaused();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + ".startPaused()ed.");
        }
        this.setState(ComponentState.PAUSED);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " paused event (transactional).");
        }
        this.componentEvents.pausedTransactional();
    }

    private void pause(boolean manual) {
        this.setState(ComponentState.PAUSING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".prePause().");
        }
        this.control.prePause();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " pausing event (transactional).");
        }
        this.componentEvents.pausingTransactional();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".pause().");
        }
        this.control.pause();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + ".paused()ed.");
        }
        this.setState(ComponentState.PAUSED);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " paused event (transactional).");
        }
        this.componentEvents.pausedTransactional();
    }

    private void resume(boolean manual) {
        this.setState(ComponentState.RESUMING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".preResume().");
        }
        this.control.preResume();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " resuming event (transactional).");
        }
        this.componentEvents.resumingTransactional();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".resume().");
        }
        this.control.resume();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + ".resum()ed.");
        }
        this.setState(ComponentState.RUNNING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " resumed event (transactional).");
        }
        this.componentEvents.resumedTransactional();
    }

    private void stop(boolean manual) {
        this.setState(ComponentState.STOPPING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".preStop().");
        }
        this.control.preStop();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending " + this.id(this.component) + " stopping event (transactional).");
        }
        this.componentEvents.stoppingTransactional();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".stop().");
        }
        this.control.stop();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + ".stop()ed.");
        }
        this.setState(ComponentState.STOPPED);
        this.componentEvents.stoppedTransactional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill(boolean manual) {
        if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
            return;
        }
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
                return;
            }
            try {
                this.setState(ComponentState.KILLING);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Calling " + this.id(this.component) + ".kill().");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.control.kill();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(this.id(this.component) + ".kill()ed.");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.setState(ComponentState.KILLED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reset() {
        this.setState(ComponentState.RESETTING);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Reseting " + this.id(this.component) + "'s controller.");
        }
        this.resetController();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + "'s controller reseted.");
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Calling " + this.id(this.component) + ".reset().");
        }
        this.control.reset();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.id(this.component) + ".reset()ed.");
        }
        this.setState(ComponentState.RESETED);
    }

    private void resetController() {
        for (IToken iToken : this.dependencies.getDependencies()) {
            this.dependencyState.put(iToken, ComponentState.RESETED);
        }
        for (ComponentState componentState : ComponentState.values()) {
            this.stateCount.put(componentState, 0);
        }
        this.stateCount.put(ComponentState.RESETED, this.dependencies.getCount());
        this.lastFatalError = null;
    }
}

