/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutJMX;
import cz.cuni.amis.pogamut.base.utils.logging.ILogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategories;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test01_JMXLogCategories
extends BaseTest {
    CountDownLatch messageReceivedLatch = new CountDownLatch(1);
    String receivedMessage = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void receiveLogEventThroughJMX() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, PogamutException, MalformedURLException, IOException, InterruptedException, MBeanException, InstanceNotFoundException, AttributeNotFoundException, ReflectionException {
        String testMsg = "TEST LOG MESSAGE FROM receiveLogEventThroughJMX()";
        ObjectName parentName = PogamutJMX.getObjectName((String)"testDomain", (String)"root", (String)"test");
        LogCategories logCategories = new LogCategories();
        String testLogCategoryNameStr = "testLogCategory";
        LogCategory testLog = logCategories.getCategory(testLogCategoryNameStr);
        JMXLogCategories jmxLogCategories = new JMXLogCategories((ILogCategories)logCategories, Pogamut.getPlatform().getMBeanServer(), parentName);
        MBeanServerConnection mbsc = Pogamut.getPlatform().getMBeanServerConnection();
        ObjectName logCatsName = jmxLogCategories.getJMXLogCategoriesName();
        String[] catNames = (String[])mbsc.getAttribute(logCatsName, "CategoryNames");
        boolean found = false;
        for (String catName : catNames) {
            if (!catName.equals(testLogCategoryNameStr)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)(testLogCategoryNameStr + " must be among exported log category names"), (boolean)found);
        ObjectName testCategoryName = (ObjectName)mbsc.invoke(logCatsName, "getJMXLogCategoryName", new Object[]{testLogCategoryNameStr}, new String[]{"java.lang.String"});
        mbsc.addNotificationListener(testCategoryName, new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                Test01_JMXLogCategories.this.receivedMessage = notification.getMessage();
                Test01_JMXLogCategories.this.messageReceivedLatch.countDown();
            }
        }, null, (Object)this);
        if (testLog.isLoggable(Level.INFO)) {
            testLog.info("TEST LOG MESSAGE FROM receiveLogEventThroughJMX()");
        }
        this.messageReceivedLatch.await(30000L, TimeUnit.MILLISECONDS);
        this.assertTrue("Received message must contain testMsg", this.receivedMessage.contains("TEST LOG MESSAGE FROM receiveLogEventThroughJMX()"));
        System.out.println("---/// TEST OK ///---");
        Pogamut.getPlatform().close();
    }
}

