/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection.impl.socket;

import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.ISocketConnectionAddress;
import cz.cuni.amis.utils.NullCheck;
import java.net.URI;
import java.net.URL;

public class SocketConnectionAddress
implements ISocketConnectionAddress {
    public static final String ADDRESS_DEPENDENCY = "HOST_DEPENDENCY";
    private String host;
    private int port;

    public SocketConnectionAddress(@Named(value="HOST_DEPENDENCY") SocketConnectionAddress address) {
        this(address.host, address.port);
    }

    public SocketConnectionAddress(String host, int port) {
        this.host = host;
        NullCheck.check((Object)host, (String)"host");
        this.port = port;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port=" + port + " is out of range.");
        }
    }

    public SocketConnectionAddress(URL url) {
        this(url.getHost(), url.getPort());
    }

    public SocketConnectionAddress(URI uri) {
        this(uri.getHost(), uri.getPort());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "SocketConnectionAddress[" + this.host + ":" + this.port + "]";
    }
}

