/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.math;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.IFilter;
import cz.cuni.amis.utils.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DistanceUtils {
    public static final GetLocatedDistance3D<ILocated> getLocatedDistance3D = new GetLocatedDistance3D();
    public static final GetLocatedDistance2D<ILocated> getLocatedDistance2D = new GetLocatedDistance2D();
    public static final AcceptAllDistanceFilter acceptAllDistanceFilter = new AcceptAllDistanceFilter();
    public static final VisibleFilter<IViewable> visibleFilter = new VisibleFilter();
    private static final DistancesComparator distancesComparator = new DistancesComparator();

    public static <T> T getNearest(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        T nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (T l : locations) {
            double d = getDistance.getDistance(l, target);
            if (!(d < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return nearest;
    }

    public static <T> T getNearest(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        if (filters == null || filters.length == 0 || filters.length == 1 && filters[0] instanceof AcceptAllDistanceFilter) {
            return DistanceUtils.getNearest(locations, target, getDistance);
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        T nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (T l : locations) {
            double d = getDistance.getDistance(l, target);
            boolean accepted = true;
            for (IDistanceFilter filter : filters) {
                if (filter.isAccepted(l, target, d)) continue;
                accepted = false;
                break;
            }
            if (!accepted || !(d < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return nearest;
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance3D, filters));
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance3D));
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getNearest(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getNearestFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getNearest(locations, target);
        }
        return DistanceUtils.getNearest(locations, target, new FilterAdapter(filter));
    }

    public static <T extends IViewable> T getNearestVisible(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNearest(locations, target, getLocatedDistance3D, visibleFilter));
    }

    public static <T> List<T> getDistanceSorted(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        ArrayList<Tuple2> distances = new ArrayList<Tuple2>(locations.size());
        for (T location : locations) {
            double distance = getDistance.getDistance(location, target);
            distances.add(new Tuple2(location, (Object)distance));
        }
        Collections.sort(distances, distancesComparator);
        ArrayList<Object> result = new ArrayList<Object>(distances.size());
        for (Tuple2 location : distances) {
            result.add(location.getFirst());
        }
        return result;
    }

    public static <T> List<T> getDistanceSorted(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        if (filters == null || filters.length == 0 || filters.length == 1 && filters[0] instanceof AcceptAllDistanceFilter) {
            return DistanceUtils.getDistanceSorted(locations, target, getDistance);
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (getDistance == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ArrayList<Tuple2> distances = new ArrayList<Tuple2>(locations.size());
        for (T location : locations) {
            boolean accepted = true;
            double distance = getDistance.getDistance(location, targetLoc);
            for (IDistanceFilter filter : filters) {
                if (filter.isAccepted(location, targetLoc, distance)) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            distances.add(new Tuple2(location, (Object)distance));
        }
        Collections.sort(distances, distancesComparator);
        ArrayList<Object> result = new ArrayList<Object>(distances.size());
        for (Tuple2 location : distances) {
            result.add(location.getFirst());
        }
        return result;
    }

    public static <T extends ILocated> List<T> getDistanceSorted(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return DistanceUtils.getDistanceSorted(locations, target, getLocatedDistance3D, filters);
    }

    public static <T extends ILocated> List<T> getDistanceSorted(Collection<T> locations, ILocated target) {
        return DistanceUtils.getDistanceSorted(locations, target, getLocatedDistance3D);
    }

    public static <T extends ILocated> List<T> getDistanceSorted(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getDistanceSorted(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> List<T> getDistanceSortedFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getDistanceSorted(locations, target);
        }
        return DistanceUtils.getDistanceSorted(locations, target, new FilterAdapter(filter));
    }

    public static <T extends IViewable> List<T> getDistanceSortedVisible(Collection<T> locations, ILocated target) {
        return DistanceUtils.getDistanceSorted(locations, target, getLocatedDistance3D, visibleFilter);
    }

    public static <T> T getSecondNearest(Collection<T> locations, ILocated target, IGetDistance getDistance) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        Object secondNearest = null;
        Object nearest = null;
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (T l : locations) {
            double distance = getDistance.getDistance(l, target);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return secondNearest;
    }

    public static <T> T getSecondNearest(Collection<T> locations, ILocated target, IGetDistance getDistance, IDistanceFilter ... filters) {
        if (filters == null || filters.length == 0 || filters.length == 1 && filters[0] instanceof AcceptAllDistanceFilter) {
            return DistanceUtils.getSecondNearest(locations, target, getDistance);
        }
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        if (target.getLocation() == null) {
            return null;
        }
        Object secondNearest = null;
        Object nearest = null;
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (T l : locations) {
            double distance = getDistance.getDistance(l, target);
            boolean accepted = true;
            for (IDistanceFilter filter : filters) {
                if (filter.isAccepted(l, target, distance)) continue;
                accepted = false;
                break;
            }
            if (!accepted) continue;
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return secondNearest;
    }

    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance3D, filters));
    }

    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target, double maxDistance) {
        return DistanceUtils.getSecondNearest(locations, target, new RangeDistanceFilter(0.0, maxDistance));
    }

    public static <T extends ILocated> T getSecondNearestFiltered(Collection<T> locations, ILocated target, IFilter filter) {
        if (filter == null) {
            return DistanceUtils.getSecondNearest(locations, target);
        }
        return DistanceUtils.getSecondNearest(locations, target, new FilterAdapter(filter));
    }

    public static <T extends IViewable> T getSecondNearestVisible(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance3D, visibleFilter));
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance2D, filters));
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target, double maxDistance) {
        return (T)((ILocated)DistanceUtils.getNearest(locations, target, getLocatedDistance2D, new RangeDistanceFilter(0.0, maxDistance)));
    }

    public static <T extends ILocated> T getNearest2DFiltered(Collection<T> locations, ILocated target, IFilter<T> filter) {
        if (filter == null) {
            return DistanceUtils.getNearest2D(locations, target);
        }
        return DistanceUtils.getNearest2D(locations, target, new FilterAdapter<T>(filter));
    }

    public static <T extends IViewable> T getNearest2DVisible(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getNearest(locations, target, getLocatedDistance2D, visibleFilter));
    }

    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target, IDistanceFilter ... filters) {
        return (T)((ILocated)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance2D, filters));
    }

    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target) {
        return (T)((ILocated)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance2D));
    }

    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target, double maxDistance) {
        return (T)((ILocated)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance2D, new RangeDistanceFilter(0.0, maxDistance)));
    }

    public static <T extends ILocated> T getSecondNearest2DFiltered(Collection<T> locations, ILocated target, IFilter<T> filter) {
        if (filter == null) {
            return DistanceUtils.getSecondNearest2D(locations, target);
        }
        return DistanceUtils.getSecondNearest2D(locations, target, new FilterAdapter<T>(filter));
    }

    public static <T extends IViewable> T getSecondNearest2DVisible(Collection<T> locations, ILocated target) {
        return (T)((IViewable)DistanceUtils.getSecondNearest(locations, target, getLocatedDistance2D, visibleFilter));
    }

    private static class DistancesComparator
    implements Comparator<Tuple2<Object, Double>> {
        private DistancesComparator() {
        }

        @Override
        public int compare(Tuple2<Object, Double> o1, Tuple2<Object, Double> o2) {
            double result = (Double)o1.getSecond() - (Double)o2.getSecond();
            if (result < 0.0) {
                return -1;
            }
            if (result > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public static class FilterAdapter<T>
    implements IDistanceFilter<T> {
        private IFilter<T> filter;

        public FilterAdapter(IFilter<T> filter) {
            this.filter = filter;
        }

        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return this.filter.isAccepted(object);
        }
    }

    public static class VisibleFilter<T extends IViewable>
    implements IDistanceFilter<T> {
        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return object.isVisible();
        }
    }

    public static class RangeDistanceFilter<T>
    implements IDistanceFilter<T> {
        private double minDistance;
        private double maxDistance;

        public RangeDistanceFilter(double minDistance, double maxDistance) {
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return this.minDistance <= distanceToTarget && distanceToTarget <= this.maxDistance;
        }
    }

    public static final class AcceptAllDistanceFilter<T>
    implements IDistanceFilter<T> {
        @Override
        public boolean isAccepted(T object, ILocated target, double distanceToTarget) {
            return true;
        }
    }

    public static interface IDistanceFilter<T> {
        public boolean isAccepted(T var1, ILocated var2, double var3);
    }

    public static class GetLocatedDistance2D<T extends ILocated>
    implements IGetDistance<T> {
        @Override
        public double getDistance(T object, ILocated target) {
            if (object.getLocation() == null) {
                return Double.MAX_VALUE;
            }
            return object.getLocation().getDistance2D(target.getLocation());
        }
    }

    public static class GetLocatedDistance3D<T extends ILocated>
    implements IGetDistance<T> {
        @Override
        public double getDistance(T object, ILocated target) {
            if (object.getLocation() == null) {
                return Double.MAX_VALUE;
            }
            return object.getLocation().getDistance(target.getLocation());
        }
    }

    public static interface IGetDistance<T> {
        public double getDistance(T var1, ILocated var2);
    }
}

