/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base3d.worldview.object;

import cz.cuni.amis.pogamut.base3d.worldview.object.IRotable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;

public class Rotation
implements IRotable,
Serializable,
Cloneable {
    public static final Rotation NONE = new Rotation(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    static final long serialVersionUID = -1964427510333336912L;
    public double yaw = 0.0;
    public double roll = 0.0;
    public double pitch = 0.0;
    public static final Pattern rotationPattern;

    public Rotation clone() {
        return new Rotation(this);
    }

    public double getYaw() {
        return this.yaw;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getRoll() {
        return this.roll;
    }

    @Override
    public Rotation getRotation() {
        return this;
    }

    public Point3d getPoint3d() {
        return new Point3d(this.pitch, this.yaw, this.roll);
    }

    public Rotation() {
    }

    public Rotation(double pitch, double yaw, double roll) {
        this.yaw = yaw;
        this.roll = roll;
        this.pitch = pitch;
    }

    public Rotation(Rotation rotation) {
        this.yaw = rotation.getYaw();
        this.roll = rotation.getRoll();
        this.pitch = rotation.getPitch();
    }

    public Rotation(String string) {
        Matcher m = rotationPattern.matcher(string);
        if (m.find()) {
            String strPitch = m.group(1);
            String strYaw = m.group(3);
            String strRoll = m.group(5);
            try {
                this.pitch = Double.parseDouble(strPitch);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Rotation, because pitch-value '" + strPitch + "' is not a number.");
            }
            try {
                this.yaw = Double.parseDouble(strYaw);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Rotation, because yaw-value '" + strYaw + "' is not a number.");
            }
            try {
                this.roll = Double.parseDouble(strRoll);
            }
            catch (Exception e) {
                throw new RuntimeException("String '" + string + "', was not matched as Rotation, because roll-value '" + strRoll + "' is not a number.");
            }
        }
        throw new RuntimeException("String '" + string + "' was not matched as Rotation.");
    }

    public static final double LinearInterp(double a, double b, double alpha) {
        return a + (b - a) * alpha;
    }

    public static final double LogInterp(double a, double b, double alpha) {
        return a + (b - a) * Math.log(1.0 + alpha * 1.718281828459045);
    }

    public static final double ExpInterp(double a, double b, double alpha) {
        return a + (b - a) * (Math.exp(alpha) - 1.0) / 1.718281828459045;
    }

    public static final Rotation RotationLinearInterp(Rotation a, Rotation b, double alpha) {
        return new Rotation(Rotation.LinearInterp(a.pitch, b.pitch, alpha), Rotation.LinearInterp(a.yaw, b.yaw, alpha), Rotation.LinearInterp(a.roll, b.roll, alpha));
    }

    public final Rotation RotationLinearInterp(Rotation b, double alpha) {
        return Rotation.RotationLinearInterp(this, b, alpha);
    }

    public static final Rotation RotationLogInterp(Rotation a, Rotation b, double alpha) {
        return new Rotation(Rotation.LogInterp(a.pitch, b.pitch, alpha), Rotation.LogInterp(a.yaw, b.yaw, alpha), Rotation.LogInterp(a.roll, b.roll, alpha));
    }

    public final Rotation RotationLogInterp(Rotation b, double alpha) {
        return Rotation.RotationLogInterp(this, b, alpha);
    }

    public static final Rotation RotationExpInterp(Rotation a, Rotation b, double alpha) {
        return new Rotation(Rotation.ExpInterp(a.pitch, b.pitch, alpha), Rotation.ExpInterp(a.yaw, b.yaw, alpha), Rotation.ExpInterp(a.roll, b.roll, alpha));
    }

    public final Rotation RotationExpInterp(Rotation b, double alpha) {
        return Rotation.RotationExpInterp(this, b, alpha);
    }

    public boolean equals(Rotation r) {
        if (r == null) {
            return false;
        }
        return this.pitch == r.pitch && this.yaw == r.yaw && this.roll == r.roll;
    }

    public static boolean equal(Rotation r1, Rotation r2) {
        return r1.pitch == r2.pitch && r1.yaw == r2.yaw && r1.roll == r2.roll;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "[%.2f; %.2f; %.2f]", this.pitch, this.yaw, this.roll);
    }

    public Location toLocation() {
        return this.toLocation(Order.PITCH_YAW_ROLL);
    }

    public Location toLocation(Order order) {
        Matrix3d yaw = Rotation.constructXYRot(this.getYaw() / 32767.0 * Math.PI);
        Matrix3d roll = Rotation.constructYZRot(this.getRoll() / 32767.0 * Math.PI);
        Matrix3d pitch = Rotation.constructXZRot(this.getPitch() / 32767.0 * Math.PI);
        Location res = new Location(1.0, 0.0, 0.0);
        switch (order) {
            case YAW_PITCH_ROLL: {
                return res.mul(yaw).mul(pitch).mul(roll);
            }
            case ROLL_PITCH_YAW: {
                return res.mul(roll).mul(pitch).mul(yaw);
            }
            case PITCH_YAW_ROLL: {
                return res.mul(pitch).mul(yaw).mul(roll);
            }
            case PITCH_ROLL_YAW: {
                return res.mul(pitch).mul(roll).mul(yaw);
            }
            case YAW_ROLL_PITCH: {
                return res.mul(yaw).mul(roll).mul(pitch);
            }
            case ROLL_YAW_PITCH: {
                return res.mul(roll).mul(yaw).mul(pitch);
            }
        }
        return null;
    }

    public static Matrix3d constructYZRot(double angle) {
        Matrix3d res = new Matrix3d();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        res.setM00(1.0);
        res.setM11(cos);
        res.setM21(-sin);
        res.setM12(sin);
        res.setM22(cos);
        return res;
    }

    public static Matrix3d constructXZRot(double angle) {
        Matrix3d res = new Matrix3d();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        res.setM00(cos);
        res.setM20(sin);
        res.setM11(1.0);
        res.setM02(-sin);
        res.setM22(cos);
        return res;
    }

    public static Matrix3d constructXYRot(double angle) {
        Matrix3d res = new Matrix3d();
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        res.setM00(cos);
        res.setM10(-sin);
        res.setM01(sin);
        res.setM11(cos);
        res.setM22(1.0);
        return res;
    }

    public Rotation setTo(Rotation r) {
        this.yaw = r.yaw;
        this.roll = r.roll;
        this.pitch = r.pitch;
        return this;
    }

    public Rotation setTo(double pitch, double yaw, double roll) {
        this.yaw = yaw;
        this.roll = roll;
        this.pitch = pitch;
        return this;
    }

    static {
        PropertyEditorManager.registerEditor(Rotation.class, PropertyEditor.class);
        rotationPattern = Pattern.compile("\\[([-+]?[0-9]+(\\.[0-9]+){0,1})\\; ([-+]?[0-9]+(\\.[0-9]+){0,1})\\; ([-+]?[0-9]+(\\.[0-9]+){0,1})\\]");
    }

    public static enum Order {
        YAW_PITCH_ROLL,
        ROLL_PITCH_YAW,
        PITCH_YAW_ROLL,
        PITCH_ROLL_YAW,
        YAW_ROLL_PITCH,
        ROLL_YAW_PITCH;

    }

    public static class PropertyEditor
    extends PropertyEditorSupport {
        @Override
        public String getAsText() {
            if (this.getValue() != null) {
                return this.getValue().toString();
            }
            return "null";
        }

        @Override
        public void setAsText(String s) {
            if ("null".equals(s.trim())) {
                this.setValue(null);
                return;
            }
            double[] d = Location.PropertyEditor.parseNumberArray(s);
            if (d.length != 3) {
                throw new IllegalArgumentException();
            }
            this.setValue(new Rotation(d[0], d[1], d[2]));
        }
    }
}

