/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.command.react;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;

public abstract class CommandReact<COMMAND extends CommandMessage> {
    protected ICommandListener<COMMAND> reactListener = new ICommandListener<COMMAND>(){

        public void notify(COMMAND event) {
            CommandReact.this.preReact(event);
            CommandReact.this.react(event);
            CommandReact.this.postReact(event);
        }
    };
    protected IAct reactAct;
    protected Class<COMMAND> reactCommandClass;
    private boolean reactHooked = false;

    public CommandReact(Class<COMMAND> commandClass, IAct worldView) {
        this.reactAct = worldView;
        this.reactCommandClass = commandClass;
        this.enable();
    }

    public synchronized void disable() {
        if (this.reactHooked) {
            this.reactHooked = false;
            this.reactAct.removeCommandListener(this.reactCommandClass, this.reactListener);
        }
    }

    public synchronized void enable() {
        if (!this.reactHooked) {
            this.reactHooked = true;
            if (!this.reactAct.isCommandListening(this.reactCommandClass, this.reactListener)) {
                this.reactAct.addCommandListener(this.reactCommandClass, this.reactListener);
            }
        }
    }

    protected void preReact(COMMAND event) {
    }

    protected abstract void react(COMMAND var1);

    protected void postReact(COMMAND event) {
    }
}

