/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.math;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.IFilter;
import java.util.Collection;

public class DistanceUtils {
    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        ILocated nearest = null;
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d;
            if (l.getLocation() == null || !((d = l.getLocation().getDistance(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target, double maxDistance) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        ILocated nearest = null;
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d;
            if (l.getLocation() == null || (d = l.getLocation().getDistance(targetLoc)) > maxDistance || !(d < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getNearestFiltered(Collection<T> locations, ILocated target, IFilter<T> filter) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ILocated nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d;
            if (l.getLocation() == null || !filter.isAccepted((Object)l) || !((d = l.getLocation().getDistance(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ILocated secondNearest = null;
        ILocated nearest = null;
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            if (l.getLocation() == null) continue;
            double distance = Location.getDistance(l.getLocation(), targetLoc);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return (T)secondNearest;
    }

    public static <T extends IViewable> T getNearestVisible(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        IViewable nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (IViewable l : locations) {
            double d;
            ILocated loc;
            if (!l.isVisible() || (loc = (ILocated)((Object)l)).getLocation() == null || !((d = loc.getLocation().getDistance(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends IViewable> T getSecondNearestVisible(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        IViewable secondNearest = null;
        IViewable nearest = null;
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (IViewable l : locations) {
            ILocated loc;
            if (!l.isVisible() || (loc = (ILocated)((Object)l)).getLocation() == null) continue;
            double distance = Location.getDistance(loc.getLocation(), targetLoc);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return (T)secondNearest;
    }

    public static <T extends ILocated> T getNearest2D(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ILocated nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d;
            if (l.getLocation() == null || !((d = l.getLocation().getDistance2D(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getNearestFiltered2D(Collection<T> locations, ILocated target, IFilter<T> filter) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ILocated nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d;
            if (!filter.isAccepted((Object)l) || l.getLocation() == null || !((d = l.getLocation().getDistance2D(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getSecondNearest2D(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        ILocated secondNearest = null;
        ILocated nearest = null;
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            if (l.getLocation() == null) continue;
            double distance = Location.getDistance2D(l.getLocation(), targetLoc);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return (T)secondNearest;
    }

    public static <T extends IViewable> T getNearestVisible2D(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        IViewable nearest = null;
        double minDistance = Double.MAX_VALUE;
        for (IViewable l : locations) {
            double d;
            ILocated loc;
            if (!l.isVisible() || (loc = (ILocated)((Object)l)).getLocation() == null || !((d = loc.getLocation().getDistance2D(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends IViewable> T getSecondNearestVisible2D(Collection<T> locations, ILocated target) {
        if (locations == null) {
            return null;
        }
        if (target == null) {
            return null;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return null;
        }
        IViewable secondNearest = null;
        IViewable nearest = null;
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (IViewable l : locations) {
            ILocated loc;
            if (!l.isVisible() || (loc = (ILocated)((Object)l)).getLocation() == null) continue;
            double distance = Location.getDistance2D(loc.getLocation(), targetLoc);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return (T)secondNearest;
    }
}

