/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.network;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.concurrent.CountDownLatch;

public class NetworkLoggingAgent
extends AbstractAgent {
    public IAgentLogic myLogic = new IAgentLogic(){

        public long getLogicInitializeTime() {
            return 1000L;
        }

        public long getLogicShutdownTime() {
            return 1000L;
        }

        public void logic() {
            if (NetworkLoggingAgent.this.logicCycles == -1) {
                return;
            }
            if (NetworkLoggingAgent.this.logicCycles == 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NetworkLoggingAgent.this.stop();
                    }
                }).start();
                --NetworkLoggingAgent.this.logicCycles;
                return;
            }
            if (NetworkLoggingAgent.this.logicLatch != null) {
                try {
                    NetworkLoggingAgent.this.logicLatch.await();
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException((Throwable)e, (Object)this);
                }
                NetworkLoggingAgent.this.logicLatch = null;
                System.out.println("[INFO] " + NetworkLoggingAgent.this.getComponentId().getToken() + " : About to send first logs...");
            }
            for (int i = 0; i < NetworkLoggingAgent.this.logsPerLogicCycle; ++i) {
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").finest("!!! I'm alive! FINEST - " + i);
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").finer("!!! I'm alive! FINER - " + i);
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").fine("!!! I'm alive! FINE - " + i);
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").info("!!! I'm alive! INFO - " + i);
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").warning("!!! I'm alive! WARNING - " + i);
                NetworkLoggingAgent.this.getLogger().getCategory("my-log").severe("!!! I'm alive! SEVERE - " + i);
            }
            --NetworkLoggingAgent.this.logicCycles;
        }

        public void logicInitialize(LogicModule logicModule) {
            NetworkLoggingAgent.this.logicLatch = new CountDownLatch(1);
            NetworkLoggingAgent.this.logicCycles = NetworkLoggingAgent.this.origLogicCycles;
        }

        public void logicShutdown() {
        }

        public void beforeFirstLogic() {
        }
    };
    private LogicModule logic;
    private int logsPerLogicCycle;
    private int logicCycles;
    private CountDownLatch logicLatch = new CountDownLatch(1);
    private int origLogicCycles;

    public CountDownLatch getLogicLatch() {
        return this.logicLatch;
    }

    public NetworkLoggingAgent(IAgentId agentId, IAgentLogger logger, double logicFrequency, int logsPerLogicCycle, int logicCycles) {
        super(agentId, (IComponentBus)new ComponentBus(logger), logger);
        logger.addDefaultNetworkHandler();
        this.logic = new LogicModule((IAgent)this, this.myLogic);
        this.logic.setLogicFrequency(logicFrequency);
        this.logsPerLogicCycle = logsPerLogicCycle;
        this.logicCycles = logicCycles;
        this.origLogicCycles = logicCycles;
    }
}

