/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.FatalErrorPropagatingEventException;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.LifecycleBus;
import cz.cuni.amis.pogamut.base.component.stub.component.AutoCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.component.CheckEvent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.tests.BaseTest;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.Test;

public class Test11_LifecycleBus
extends BaseTest {
    @Test
    public void test01() {
        AgentId agentId = new AgentId("Test05_LifecycleBus");
        AgentLogger logger = new AgentLogger((IAgentId)agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        LifecycleBus bus = new LifecycleBus((IAgentLogger)logger);
        AutoCheckComponent comp1 = new AutoCheckComponent((IAgentLogger)logger, (IComponentBus)bus);
        IComponentEventListener<IComponentEvent> listener = new IComponentEventListener<IComponentEvent>((ILifecycleBus)bus, comp1){
            final /* synthetic */ ILifecycleBus val$bus;
            final /* synthetic */ AutoCheckComponent val$comp1;
            {
                this.val$bus = iLifecycleBus;
                this.val$comp1 = autoCheckComponent;
            }

            public void notify(IComponentEvent event) {
                if (event instanceof IFatalErrorEvent) {
                    return;
                }
                this.val$bus.event((IComponentEvent)new StartedEvent((IComponent)this.val$comp1));
                this.val$bus.event((IComponentEvent)new FatalErrorEvent((IComponent)this.val$comp1, "You are doomed!"));
            }
        };
        bus.addEventListener(IComponentEvent.class, (IComponentEventListener)listener);
        CheckEvent[] checkEvents = new CheckEvent[]{new CheckEvent((IComponentEvent)new StartingEvent((IComponent)comp1)), new CheckEvent(FatalErrorEvent.class, comp1)};
        comp1.expect(checkEvents);
        boolean exception = false;
        try {
            bus.event((IComponentEvent)new StartingEvent((IComponent)comp1));
        }
        catch (FatalErrorPropagatingEventException e) {
            exception = true;
        }
        Assert.assertTrue((String)"bus should throw an exception when fatal error happens during the propagation of the event", (boolean)exception);
        Assert.assertTrue((String)"bus should not be running after fatal error", (!bus.isRunning() ? 1 : 0) != 0);
        comp1.checkExpectEmpty();
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test11_LifecycleBus test = new Test11_LifecycleBus();
        test.test01();
    }
}

