/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.worldview.objects;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.multi.agent.ITeamId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedPropertyUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ISharedProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.LongProperty;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.PropertyId;
import cz.cuni.amis.pogamut.multi.communication.worldview.property.StringProperty;
import cz.cuni.amis.pogamut.multi.worldview.objects.TestSharedObject;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class TestSharedObjectImpl
extends TestSharedObject {
    private static FlagInteger instances = new FlagInteger(Integer.valueOf(0));
    protected StringProperty stringProperty;
    protected LongProperty longProperty;
    protected HashMap<PropertyId, ISharedProperty> propertyMap = new HashMap(2);

    public static ImmutableFlag<Integer> getInstances() {
        return instances.getImmutable();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        instances.decrement(1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TestSharedObjectImpl(Collection<ISharedProperty> properties) {
        instances.increment(1);
        long simTime = 0L;
        boolean longSet = false;
        boolean stringSet = false;
        for (ISharedProperty p : properties) {
            if (this.objectId == null) {
                this.objectId = p.getObjectId();
            } else if (this.objectId != p.getObjectId()) {
                throw new PogamutException("Ids don't match in creating TestSharedObject", (Object)this);
            }
            if (p.getPropertyValueClass() == Long.class) {
                if (longSet) throw new PogamutException("Trying to create TestSharedObject with more than one longProperty", (Object)this);
                this.longProperty = (LongProperty)p;
                longSet = true;
            } else if (p.getPropertyValueClass() == String.class) {
                if (stringSet) throw new PogamutException("Trying to create TestSharedObject with more than one stringProperty", (Object)this);
                this.stringProperty = (StringProperty)p;
                stringSet = true;
            }
            this.propertyMap.put(p.getPropertyId(), p);
        }
        if (longSet && stringSet) return;
        throw new PogamutException("Not all properties provided while creating TestSharedObject", (Object)this);
    }

    public ISharedProperty getProperty(PropertyId id) {
        return this.propertyMap.get(id);
    }

    public Map<PropertyId, ISharedProperty> getProperties() {
        return this.propertyMap;
    }

    @Override
    public TestSharedObject clone() {
        return new TestSharedObjectImpl(this.propertyMap.values());
    }

    @Override
    public String getSharedString() {
        return (String)this.stringProperty.getValue();
    }

    @Override
    public long getSharedLong() {
        return (Long)this.longProperty.getValue();
    }

    @Override
    public TestSharedObjectUpdatedEvent createUpdateEvent(long simTime, ITeamId teamId) {
        return new TestSharedObjectUpdatedEvent(this, simTime, teamId);
    }

    public String toString() {
        return "TestSharedObjectImpl[id=" + this.getId() + ", time=" + this.getSimTime() + ", sharedString=" + this.getSharedString() + ", sharedLong=" + this.getSharedLong() + "]";
    }

    public static class TestSharedObjectUpdatedEvent
    implements ISharedWorldObjectUpdatedEvent {
        private TestSharedObject obj;
        private long time;
        private ITeamId teamId;

        public TestSharedObjectUpdatedEvent(TestSharedObject obj, long time, ITeamId teamId) {
            this.obj = obj;
            this.time = time;
            this.teamId = teamId;
        }

        public long getSimTime() {
            return this.time;
        }

        public WorldObjectId getId() {
            return this.obj.getId();
        }

        public ITeamId getTeamId() {
            return this.teamId;
        }

        public Collection<ISharedPropertyUpdatedEvent> getPropertyEvents() {
            LinkedList<ISharedPropertyUpdatedEvent> ret = new LinkedList<ISharedPropertyUpdatedEvent>();
            for (ISharedProperty p : this.obj.getProperties().values()) {
                ret.add(p.createUpdateEvent(this.time, this.teamId));
            }
            return ret;
        }

        public String toString() {
            return "TestSharedObjectUpdatedEvent[id=" + this.getId() + ", time=" + this.getSimTime() + "]";
        }

        public Class getCompositeObjectClass() {
            return this.obj.getCompositeClass();
        }
    }
}

