/*
Gamebots Pogamut derivation Copyright (c) 2010-2011, Michal Bida, Radek Pibil

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This software must also be in compliance with the Epic Games Inc. license for mods which states the following: "Your mods must be distributed solely for free, period. Neither you, nor any other person or party, may sell them to anyone, commercially exploit them in any way, or charge anyone for receiving or using them without prior written consent of Epic Games Inc. You may exchange them at no charge among other end-users and distribute them to others over the Internet, on magazine cover disks, or otherwise for free." Please see http://www.epicgames.com/ut2k4_eula.html for more information.

*/
class BotCTFGame extends UTCTFGame
	implements(GBGameInterface);

var GBCTFGameHandler handler;

//this function is called even before PreBeginPlay, we parse GB parameters from
//command line here
event InitGame(string Options, out string Error )
{
	handler = Spawn(class'GBCTFGameHandler', self);

	handler.InitGame(Options, Error);
}

function SuperInitGame(string Options, out string Error)
{
	super.InitGame(Options, Error);
}

//This function is automaticaly called after beginning of the game
function PostBeginPlay()
{
	handler.HandlerPostBeginPlay();
}

function SuperPostBeginPlay()
{
	super.PostBeginPlay();
}

//we override this to disable accepting of connections when game is ending
function EndGame(PlayerReplicationInfo Winner, string Reason)
{
	handler.EndGame(Winner, Reason);
}

function SuperEndGame(PlayerReplicationInfo Winner, string Reason)
{
	super.EndGame(Winner, Reason);
}

//Called when new human player enters the game
event PlayerController Login(string Portal, string Options, const UniqueNetId UniqueId, out string ErrorMessage)
{
	return handler.Login(Portal, Options, UniqueId, ErrorMessage);
}

function PlayerController SuperLogin(string Portal, string Options, const UniqueNetId UniqueId, out string ErrorMessage)
{
	return super.Login(Portal, Options, UniqueId, ErrorMessage);
}

//Called when somebody (bot/player) leaves game
function Logout(controller Exiting)
{
	handler.Logout(Exiting);
}

function SuperLogout(controller Exiting)
{
	super.Logout(Exiting);
}

function GameInfoLogout(Controller Exiting)
{
	Super(GameInfo).Logout(Exiting);
}

function AddDefaultInventory( pawn PlayerPawn )
{
	handler.AddDefaultInventory(PlayerPawn);
}

function SuperAddDefaultInventory( pawn PlayerPawn )
{
	super.AddDefaultInventory(PlayerPawn);
}

function GBCTFGameHandler GetCTFGameHandler()
{
	return handler;
}

function GBTeamGameHandler GetTeamGameHandler()
{
	return handler;
}

function GBGameHandler GetGameHandler()
{
	return handler;
}

//Prevents epic bots from automatically joining the game
function bool NeedPlayers()
{
	return false;
}

function NotifyKilled( Controller Killer, Controller KilledPlayer, Pawn KilledPawn, class<DamageType> damageType )
{
	handler.NotifyKilled(Killer, KilledPlayer, KilledPawn, damageType);
}

function SuperNotifyKilled(Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType )
{
	super.NotifyKilled(Killer, Killed, KilledPawn, damageType);
}

defaultproperties
{
	bUseClassicHUD=true //if false, default HUD will be used...
	HUDType=class'GameBotsUDK.GBHUD'
	CountDown=0	
	DefaultPawnClass=class'GameBotsUDK.GBPawn'
	bDebug=true
	bPauseable=True
	PlayerReplicationInfoClass=class'GBReplicationInfo'

	bUndrivenVehicleDamage=true
	bSpawnInTeamArea=true
	bScoreTeamKills=False
	MapPrefixes[0]="CTF"
	Acronym="BCTF"
	TeamAIType(0)=class'UTGame.UTCTFTeamAI'
	TeamAIType(1)=class'UTGame.UTCTFTeamAI'
	bScoreVictimsTarget=true
	DeathMessageClass=class'UTTeamDeathMessage'
	FlagKillMessageName=FLAGKILL

	OnlineGameSettingsClass=class'UTGameSettingsCTF'

	AnnouncerMessageClass=class'UTCTFMessage'
 	TeamScoreMessageClass=class'UTGameContent.UTTeamScoreMessage'

	bScoreDeaths=false
	MidgameScorePanelTag=CTFPanel
}
