package cz.cuni.amis.pogamut.emohawk.examples.simplebot;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.TargetApproachingProperties;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.CharacterType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.NewEmoticonEvent;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashSet;
import java.util.Random;

/**
 * PogamutEmohawk's "Hello world!" example showing basics of animation and emoticon
 * invoking and player follow behavior.
 * <p><p>
 *
 * @author Michal Bida aka Knight
 * @author Rudolf Kadlec aka ik
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class EmohawkSimpleBot extends EmohawkBotController {

    /** heatup that we use to introduce delay between two consequent emoticons - 6 seconds*/
    Heatup dialogPause = new Heatup(6000);
    /** how often we react to bump event */
    Heatup emoticonResponsePause = new Heatup(6000);
    /** hash set with greeted players */
    HashSet<UnrealId> greetedPlayers = new HashSet();
    /** current target we are heading to */
    Player currentPlayerTarget;
    /**
     * Bump event listener.
     */
    IWorldEventListener<NewEmoticonEvent> newEmoticonListener = new IWorldEventListener<NewEmoticonEvent>() {

        @Override
        public void notify(NewEmoticonEvent event) {
            if (emoticonResponsePause.isCool()) {
                if (info.isMoving()) {
                    steering.stopNavigation();
                    getAct().act(new Stop());
                }
                animations.playAnimation(AnimType.AMBI_LOOKAROUND01);
                //set emoticon for 5 seconds
                if (new Random(System.currentTimeMillis()).nextBoolean()) {
                    emoticons.setCenterEmoticonType(EmoticonType.SECOND_GIRL_66, 5);
                } else {
                    emoticons.setCenterEmoticonType(EmoticonType.FIRST_GIRL_68, 5);
                }
                dialogPause.heat();
                emoticonResponsePause.heat();
            }
        }
    };

    /**
     * Initialize all necessary variables here, before the bot actually receives anything
     * from the environment.
     */
    @Override
    public void prepareBot(UT2004Bot bot) {
        // By uncommenting following line, you can make the bot to do the file logging of all its components
        //bot.getLogger().addDefaultFileHandler(new File("EmptyBot.log"));
    }

    /**
     * Here we can modify initializing command for our bot, e.g., sets its name or skin.
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmohawkSimpleBot").setClassName(CharacterType.THOMAS.getUE2Class());
    }

    /**
     * Handshake with GameBots2004 is over - bot has information about the map in its world view.
     * Many agent modules are usable since this method is called.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    /**
     * The bot is initilized in the environment - a physical representation of the bot is present in the game.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     * @param self information about the agent
     */
    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        // Display a welcome message in the game engine
        // right in the time when the bot appears in the environment, i.e., his body has just been spawned
        // into the UT2004 for the first time.
        comm.sendGlobalTextMessage("Hello world! I am alive!");

        // alternatively, you may use getAct() method for issuing arbitrary {@link CommandMessage} for the bot's body
        // inside UT2004
        getAct().act(new SendMessage().setGlobal(true).setText("And I can speak! Hurray!"));
        //adding listener to bump message
        getWorldView().addEventListener(NewEmoticonEvent.class, newEmoticonListener);
    }

    /**
     * Main method that controls the bot - makes decisions what to do next.
     * It is called iteratively by Pogamut engine every time a synchronous batch
     * from the environment is received. This is usually 4 times per second - it
     * is affected by visionTime variable, that can be adjusted in GameBots ini file in
     * UT2004/System folder.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
    @Override
    public void logic() throws PogamutException {
        if (currentPlayerTarget != null && currentPlayerTarget.isVisible()) {
            if (info.atLocation(currentPlayerTarget.getLocation(), 300)) {
                if (!info.isMoving()) {
                    if (dialogPause.isCool()) {
                        if (!greetedPlayers.contains((currentPlayerTarget.getId()))) {
                            //greet player
                            animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                            emoticons.setCenterEmoticonType(EmoticonType.HI_213, 5);
                            greetedPlayers.add((currentPlayerTarget).getId());
                        } else {
                            animations.playAnimation(AnimType.SOCIAL_EXPLAIN);
                            emoticons.setCenterEmoticonType(EmoticonType.BLAHBLAHBLAH_215, 5);
                        }
                        dialogPause.heat();
                    }
                } else {
                    //stop the bot
                    steering.stopNavigation();
                    animations.playAnimation(AnimType.AMBI_STAND_NORMAL01, true);
                }
            } else {
                if (!steering.isNavigating()) {
                    if (!steering.isTargetApproachingActive()) {
                        steering.addTargetApproachingSteering(new TargetApproachingProperties(400, currentPlayerTarget.getLocation()));
                    }
                    if (!steering.isObstacleAvoidanceActive()) {
                        steering.addObstacleAvoidanceSteering(new ObstacleAvoidanceProperties());
                    }
                    steering.startNavigation();
                }

                steering.setTargetApproachingSteering(new TargetApproachingProperties(400, currentPlayerTarget.getLocation()));
            }
        } else {
            if (players.canSeePlayers()) {
                Player pl = players.getNearestVisiblePlayer();
                if (pl != null) {
                    currentPlayerTarget = pl;
                    return;
                }
            }

            if (!info.isMoving() && dialogPause.isCool()) {
                animations.playAnimation(AnimType.AMBI_SCRATCH);
                emoticons.setCenterEmoticonType(EmoticonType.YAWN_254, 5);
                dialogPause.heat();
            }
        }

        if (info.isMoving() && (info.getSelf().getAnim() == null || !info.getSelf().getAnim().contains("walk_normal01"))) {
            animations.playAnimation(AnimType.WALK_NORMAL01, true);
        }
    }

    /**
     * Called each time the bot dies. Good for reseting all bot's state dependent variables.
     *
     * @param event
     */
    @Override
    public void botKilled(BotKilled event) {
        // First, try to run the bot and kill it... than uncomment this line and run the bot again
        // kill it and see the difference.
        //body.getCommunication().sendGlobalTextMessage("I was KILLED!");
    }

    /**
     * This method is called when the bot is started either from IDE or from command line.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
        // wrapped logic for bots executions, suitable to run single bot in single JVM
        new UT2004BotRunner(EmohawkSimpleBot.class, "EmohawkSimpleBot").setHost("localhost").setPort(3000).setMain(true).startAgent();
    }
}
