/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.simplebot;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.TargetApproachingProperties;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.AnimType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.CharacterType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.EmoticonType;
import cz.cuni.amis.pogamut.emohawk.agent.module.sensomotoric.NewEmoticonEvent;
import cz.cuni.amis.pogamut.emohawk.bot.impl.EmohawkBotController;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SendMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.Heatup;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.HashSet;
import java.util.Random;

@AgentScoped
public class EmohawkSimpleBot
extends EmohawkBotController {
    Heatup dialogPause = new Heatup(6000L);
    Heatup emoticonResponsePause = new Heatup(6000L);
    HashSet<UnrealId> greetedPlayers = new HashSet();
    Player currentPlayerTarget;
    IWorldEventListener<NewEmoticonEvent> newEmoticonListener = new IWorldEventListener<NewEmoticonEvent>(){

        public void notify(NewEmoticonEvent event) {
            if (EmohawkSimpleBot.this.emoticonResponsePause.isCool()) {
                if (EmohawkSimpleBot.this.info.isMoving().booleanValue()) {
                    EmohawkSimpleBot.this.steering.stopNavigation();
                    EmohawkSimpleBot.this.getAct().act((CommandMessage)new Stop());
                }
                EmohawkSimpleBot.this.animations.playAnimation(AnimType.AMBI_LOOKAROUND01);
                if (new Random(System.currentTimeMillis()).nextBoolean()) {
                    EmohawkSimpleBot.this.emoticons.setCenterEmoticonType(EmoticonType.SECOND_GIRL_66, 5.0);
                } else {
                    EmohawkSimpleBot.this.emoticons.setCenterEmoticonType(EmoticonType.FIRST_GIRL_68, 5.0);
                }
                EmohawkSimpleBot.this.dialogPause.heat();
                EmohawkSimpleBot.this.emoticonResponsePause.heat();
            }
        }
    };

    public void prepareBot(UT2004Bot bot) {
    }

    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmohawkSimpleBot").setClassName(CharacterType.THOMAS.getUE2Class());
    }

    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.comm.sendGlobalTextMessage("Hello world! I am alive!");
        this.getAct().act((CommandMessage)new SendMessage().setGlobal(Boolean.valueOf(true)).setText("And I can speak! Hurray!"));
        this.getWorldView().addEventListener(NewEmoticonEvent.class, this.newEmoticonListener);
    }

    public void logic() throws PogamutException {
        if (this.currentPlayerTarget != null && this.currentPlayerTarget.isVisible()) {
            if (this.info.atLocation((ILocated)this.currentPlayerTarget.getLocation(), 300.0)) {
                if (!this.info.isMoving().booleanValue()) {
                    if (this.dialogPause.isCool()) {
                        if (!this.greetedPlayers.contains(this.currentPlayerTarget.getId())) {
                            this.animations.playAnimation(AnimType.SOCIAL_WAVENEAR);
                            this.emoticons.setCenterEmoticonType(EmoticonType.HI_213, 5.0);
                            this.greetedPlayers.add(this.currentPlayerTarget.getId());
                        } else {
                            this.animations.playAnimation(AnimType.SOCIAL_EXPLAIN);
                            this.emoticons.setCenterEmoticonType(EmoticonType.BLAHBLAHBLAH_215, 5.0);
                        }
                        this.dialogPause.heat();
                    }
                } else {
                    this.steering.stopNavigation();
                    this.animations.playAnimation(AnimType.AMBI_STAND_NORMAL01, true);
                }
            } else {
                if (!this.steering.isNavigating()) {
                    if (!this.steering.isTargetApproachingActive()) {
                        this.steering.addTargetApproachingSteering(new TargetApproachingProperties(400, this.currentPlayerTarget.getLocation()));
                    }
                    if (!this.steering.isObstacleAvoidanceActive()) {
                        this.steering.addObstacleAvoidanceSteering(new ObstacleAvoidanceProperties());
                    }
                    this.steering.startNavigation();
                }
                this.steering.setTargetApproachingSteering(new TargetApproachingProperties(400, this.currentPlayerTarget.getLocation()));
            }
        } else {
            Player pl;
            if (this.players.canSeePlayers() && (pl = this.players.getNearestVisiblePlayer()) != null) {
                this.currentPlayerTarget = pl;
                return;
            }
            if (!this.info.isMoving().booleanValue() && this.dialogPause.isCool()) {
                this.animations.playAnimation(AnimType.AMBI_SCRATCH);
                this.emoticons.setCenterEmoticonType(EmoticonType.YAWN_254, 5.0);
                this.dialogPause.heat();
            }
        }
        if (this.info.isMoving().booleanValue() && (this.info.getSelf().getAnim() == null || !this.info.getSelf().getAnim().contains("walk_normal01"))) {
            this.animations.playAnimation(AnimType.WALK_NORMAL01, true);
        }
    }

    public void botKilled(BotKilled event) {
    }

    public static void main(String[] args) throws PogamutException {
        new UT2004BotRunner(EmohawkSimpleBot.class, "EmohawkSimpleBot").setHost("localhost").setPort(3000).setMain(true).startAgent();
    }
}

