package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;

public class TimedTask extends AbstractTask<TimedTask.Stage> {
	
	protected double maxDuration;
	protected double startTime;
	
	/** Create a pick up an item task  
	 * 
	 * @param bot bot picking up the item
	 */
	public TimedTask( EmohawkVilleChefBot<?> bot, double maxDuration, ITask task ) {
		super( bot, Stage.DONE, Stage.FAILED );
		this.maxDuration = maxDuration;
		this.subTask = task;
		startTime = bot.getInfo().getTime();
	}
	
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( subTask.hasSucceded() ) {
			stage = Stage.DONE;
			return;
		}
		
		if ( subTask.hasFailed() ) {
			stage = Stage.FAILED;
			return;
		}
		
		if ( bot.getInfo().getTime() > startTime + maxDuration ) {
			stage = Stage.FAILED;
			return;
		} else {
			stage = Stage.DO;
		}
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case DO:
			subTask.logic();
			break;
		case DONE:
		case FAILED:
			clearSubTask();
			break;
		}
	}
	
	@Override
	public String getName() {
		return "Time";
	}
	
	protected enum Stage {
		DO,
		DONE,
		FAILED
	}
}
