package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IPossessor;

/** Take an item from a non-ethereal container at known location
 * 
 * @author Paletz
 */
public class TakeFromContainerTask extends AbstractTask<TakeFromContainerTask.Stage> {

	protected double searchDuration;
	protected int containerGameObjectId;
	protected int itemGameObjectId;
	
	protected GoToTask goToTask;
	
	/** Create a pick up an item task  
	 * 
	 * @param bot bot picking up the item
	 * @param container container
	 * @param item item to take
	 * @param searchDuration how old item memorization is acceptable
	 */
	public TakeFromContainerTask( EmohawkVilleChefBot<?> bot, IContainer container, IItem item, double searchDuration ) {
		super( bot, Stage.DONE, Stage.FAILED );
		this.searchDuration = searchDuration;
		this.containerGameObjectId = container.getGameObjectId();
		this.itemGameObjectId = item.getGameObjectId();
	}
		
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( findWantedItem( bot.getPawn() ) != null ) {
			stage = Stage.DONE;
			return;
		}
		
		IContainerMemorization<?> container = findContainerInMemory();
		if ( container == null || bot.getInfo().getTime() - container.getMemorizationEpochTime() > searchDuration || findWantedItem( container ) == null ) {
			stage = Stage.FAILED;
			return;
		}
		
		bot.getObservationMemory().setImportance( container, 16.0 );
		
		if ( bot.getInfo().getDistance( container.getActorLocation() ) < bot.getActionRegistry().getTakeItemFromContainerAction().getRange()*0.9 ) {
			if ( container.getMemorizationEpochTime() == bot.getObservationMemory().getEpochTime() ) {
				stage = Stage.TAKE;
			} else {
				stage = Stage.SEARCH;
			}
		} else {
			stage = Stage.MOVE;
		}
		return;
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case MOVE:
			clearIncorrectSubtask( goToTask );

			if ( subTask == null ) {
				subTask = goToTask = new GoToTask(
					bot, 
					findContainerInMemory().getActorLocation(),
					bot.getActionRegistry().getTakeItemFromContainerAction().getRange()*0.9 
				);
			}
			
			subTask.logic();
			break;
		case SEARCH:
			clearSubTask();
			bot.getMove().turnTo( findContainerInMemory().getActorLocation() );
			break;
		case TAKE:
			clearSubTask();
			IContainerMemorization<?> container = findContainerInMemory();
			IContainerReplica containerReplica = bot.getObservationMemory().getPreimage( container );
			IItemReplica itemReplica = (IItemReplica) findWantedItem( containerReplica );
			bot.getActionRegistry().getTakeItemFromContainerAction().request( 
				bot.getPawn(),
				containerReplica,
				itemReplica,
				new ActionErrorPrinter( "Pick up "+itemReplica.getDisplayName() )
			);
			break;
		case DONE:
		case FAILED:
			clearSubTask();
			break;
		default:
			throw new AssertionError( "Unexpected stage: "+stage );
		}
	}
	
	@Override
	protected void clearSubTask() {
		super.clearSubTask();
		goToTask = null;
	}
	
	@Override
	public String getName() {
		return "TakeFromContainer";
	}
	
	protected IItem findWantedItem( IPossessor possessor ) {
		for ( IItem item : possessor.readInventory() ) { 
			if ( item.getGameObjectId() == itemGameObjectId ) {
				return item;
			}
		}
		return null;
	}
	
	protected IContainerMemorization<?> findContainerInMemory() {
		for ( IContainerMemorization<?> container : bot.getObservationMemory().getAllByMemorization( IContainerMemorization.class ) ) {
			if ( container.getGameObjectId() == containerGameObjectId ) {
				return container;
			}
		}
		return null;
	}
		
	protected enum Stage {
		INIT,
		MOVE,
		SEARCH,
		TAKE,
		DONE,
		FAILED
	}
}
