package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import java.util.List;
import java.util.Random;

import com.google.common.base.Supplier;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;

public class SearchTask extends AbstractTask<SearchTask.Stage> {
	
	protected static final double LOOK_AROUND_DURATION = 2.0;
	
	protected List<? extends ILocated> locations;
	protected Supplier<Boolean> hasFound;
	
	protected GoToTask goToTask;
	protected ITask lookAroundTask;
	
	public SearchTask( EmohawkVilleChefBot<?> bot, List<? extends ILocated> locations, Supplier<Boolean> hasFound ) {
		super( bot, Stage.DONE, null );
		this.locations = locations;
		this.hasFound = hasFound;
	}
	
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( hasFound.get() ) {
			stage = Stage.DONE;
			return;
		}
		
		if ( stage == null ) {
			stage = Stage.LOOK;
			return;
		}
		
		if ( subTask instanceof GoToTask && subTask.hasFinished() ) {
			stage = Stage.LOOK;
			return;
		}
		
		if ( subTask instanceof TimedTask && subTask.hasFinished() && locations.size() > 0 ) {
			stage = Stage.MOVE;
			return;
		}
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case MOVE:
			clearIncorrectSubtask( goToTask );
			
			if ( subTask == null ) {
				Location destination = locations.get( new Random().nextInt( locations.size() ) ).getLocation();
				subTask = goToTask = new GoToTask( bot, destination.getLocation(), 50 );
			}
			
			subTask.logic();
			break;
		case LOOK:
			clearIncorrectSubtask( lookAroundTask );
			
			if ( subTask == null ) {
				lookAroundTask = new LookAroundTask( bot );
				if ( locations.size() > 0 ) {
					lookAroundTask = new TimedTask( bot, LOOK_AROUND_DURATION, lookAroundTask );
				}
				subTask = lookAroundTask;
			}
			
			subTask.logic();
			break;
		case DONE:
			break;
		}
	}
	
	@Override
	protected void clearSubTask() {
		super.clearSubTask();
		goToTask = null;
		lookAroundTask = null;
	}
	
	@Override
	public String getName() {
		return "Search";
	}
	
	protected enum Stage {
		MOVE,
		LOOK,
		DONE
	}
}
