package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;

/** Pick up an item at known location task
 * 
 * Uses observation memory to determine failure.
 * 
 * @author Paletz
 */
public class PickUpTask extends AbstractTask<PickUpTask.Stage> {
	
	protected double searchDuration;
	protected int itemGameObjectId;
	
	protected GoToTask goToTask;
	
	/** Create a pick up an item task  
	 *  
	 * @param bot bot picking up the item
	 * @param item item to pick up
	 * @param searchDuration how old item memorization is acceptable
	 */
	public PickUpTask( EmohawkVilleChefBot<?> bot, IItem item, double searchDuration ) {
		super( bot, Stage.DONE, Stage.FAILED );
		this.searchDuration = searchDuration;
		this.itemGameObjectId = item.getGameObjectId();
	}
	
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( isPossessed() ) {
			stage = Stage.DONE;
			return;
		}
		
		IItemMemorization<?> item = findItemInMemory();
		if ( item == null || bot.getInfo().getTime()-item.getMemorizationEpochTime() > searchDuration ) {
			stage = Stage.FAILED;
			return;
		}
		
		bot.getObservationMemory().setImportance( item, 16.0 );
		
		if ( bot.getInfo().getDistance( item.getActorLocation() ) < bot.getActionRegistry().getPickUpItemAction().getRange()*0.9 ) {
			if ( item.getMemorizationEpochTime() == bot.getObservationMemory().getEpochTime() ) {
				stage = Stage.PICK;
			} else {
				stage = Stage.SEARCH;
			}
			return;
		} else {
			stage = Stage.MOVE;
			return;
		}
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case MOVE:
			clearIncorrectSubtask( goToTask );
			
			if ( subTask == null ) {
				subTask = goToTask = new GoToTask( bot, findItemInMemory().getActorLocation(), bot.getActionRegistry().getPickUpItemAction().getRange()*0.9 );
			}

			subTask.logic();
			break;
		case SEARCH:
			clearSubTask();
			bot.getMove().turnTo( findItemInMemory().getActorLocation() );
			break;
		case PICK:
			clearSubTask();
			IItemMemorization<?> itemMemorization = findItemInMemory();
			IItemReplica itemReplica = bot.getObservationMemory().getPreimage( itemMemorization );
			bot.getActionRegistry().getPickUpItemAction().request(
				bot.getPawn(),
				itemReplica, 
				new ActionErrorPrinter( "Pick up "+itemReplica.getDisplayName() ) 
			);
			break;
		case DONE:
		case FAILED:
			clearSubTask();
			break;
		default:
			throw new AssertionError( "Unexpected stage: "+stage );
		}
	}
	
	@Override
	protected void clearSubTask() {
		super.clearSubTask();
		goToTask = null;
	}
	
	protected boolean isPossessed() {
		for ( IItem item : bot.getPawn().readInventory() ) {
			if ( item.getGameObjectId() == itemGameObjectId ) {
				return true;
			}
		}
		
		return false;
	}
	
	@Override
	public String getName() {
		return "Pick up";
	}
	
	protected IItemMemorization<?> findItemInMemory() {
		for ( IItemMemorization<?> item : bot.getObservationMemory().getAllByMemorization( IItemMemorization.class ) ) {
			if ( item.getGameObjectId() == itemGameObjectId ) {
				return item;
			}
		}
		return null;
	}
		
	protected enum Stage {
		MOVE,
		SEARCH,
		PICK,
		DONE,
		FAILED
	}
}