package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;

import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.FryingPanMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IFriableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ITurner;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.FryingPanReplica;

/** A task to fry the contents of the cooking pot on the specified stove plate.
 * 
 * @author Paletz
 */
public class FryTask extends AbstractCookTask {

	/** Constructor
	 * 
	 * @param bot bot
	 * @param stovePlate stove plate
	 * @param searchDuration how old board memorization is acceptable
	 */
	public FryTask(
		EmohawkVilleChefBot<?> bot,
		IStovePlate stovePlate,
		double searchDuration
	) {
		super(bot, stovePlate, searchDuration);
	}

	@Override
	protected Predicate<IItem> getToolPredicate() {
		return turnerPredicate;
	}

	@Override
	protected boolean isCooked(IIngredient ingredient) {
		if ( ingredient instanceof IFriableIngredient ) {
			IFriableIngredient friableIngredient = (IFriableIngredient) ingredient;
			return (
				friableIngredient.getBottomFriedness() == 1.0
				&&
				friableIngredient.getTopFriedness() == 1.0
			);
		} else {
			// treat as cooked if not friable
			return true;
		}
	}

	@Override
	protected float getCookingRange() {
		return Math.min(
			bot.getActionRegistry().getSetStovePowerAction().getRange(),
			bot.getActionRegistry().getFlipIngredientsAction().getRange()
		);
	}
	
	@Override
	protected float getMinCookingTemperature() {
		return 150.0f;
	}

	@Override
	protected float getMaxCookingTemperature() {
		return 180.0f;
	}

	@Override
	protected void cookingLogic() {
		FryingPanReplica cookware = bot.getObservationMemory().getPreimage( findCookwareInMemory() );
		for ( IIngredient ingredient : cookware.readIngredients() ) {
			if ( ingredient instanceof IFriableIngredient ) {
				IFriableIngredient friableIngredient = (IFriableIngredient) ingredient;
				if ( friableIngredient.getIsUpsideDown() ) {
					if ( friableIngredient.getTopFriedness() < 1.0 ) {
						return;
					}
				} else {
					if ( friableIngredient.getBottomFriedness() < 1.0 ) {
						return;
					}
				}
			}
		}
		
		bot.getActionRegistry().getFlipIngredientsAction().request(
			bot.getPawn(),
			cookware,
			new ActionErrorPrinter( "Flip" )
		);
	}

	@Override
	protected int getTargetStovePower() {
		return 4;
	}

	@Override
	public String getName() {
		return "Fry";
	}
	
	@Override
	protected FryingPanMemorization findCookwareInMemory() {
		return (FryingPanMemorization) super.findCookwareInMemory();
	}
	
	protected static final Predicate<IItem> turnerPredicate = new Predicate<IItem>() {
		@Override
		public boolean apply( IItem item ) {
			return item instanceof ITurner;
		}
	};
}
