package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;

import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IFriableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IOil;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.IFryingPan;

/** Acquire fried ingredient task.
 * 
 * The result is a fried ingredient in a cookware.
 *  
 * @author Paletz
 *
 */
public class AcquireFriedIngredientTask extends AbstractAcquireCookedIngredientTask {

	/** Constructor
	 * 
	 * @param bot bot
	 * @param ingredientClass ingredient class (should be general interface, not memorization or replica)
	 * @param goalVolume goal cooked ingredient volume, supported maximum {@link #MAX_GOAL_VOLUME}
	 */
	public AcquireFriedIngredientTask(
		EmohawkVilleChefBot<?> bot,
		Class<? extends IFriableIngredient> ingredientClass,
		double goalVolume
	) {
		super(bot, ingredientClass, goalVolume);
	}

	@Override
	protected boolean isCompatibleCookware(ICookware cookware) {
		return cookware instanceof IFryingPan;
	}

	@Override
	protected Predicate<IItem> getCookingLiquidPredicate() {
		return oilPredicate;
	}

	@Override
	protected float getMinCookingLiquidVolume() {
		return 0.01f;
	}

	@Override
	protected float getMaxCookingLiquidVolume() {
		return 0.02f;
	}

	@Override
	protected boolean isCooked(IIngredient ingredient) {
		if ( ingredient instanceof IFriableIngredient ) {
			IFriableIngredient friableIngredient = (IFriableIngredient) ingredient;
			return (
				friableIngredient.getBottomFriedness() == 1.0
				&&
				friableIngredient.getTopFriedness() == 1.0
			);
		} else {
			// treat as cooked if not friable
			return true;
		}
	}

	@Override
	protected ITask makeCookTask() {
		return new FryTask(
			bot,
			(IStovePlate) findCookwareInMemory( CookwareState.PLACED_READY ).getOwnerPossessor(), 
			Double.POSITIVE_INFINITY 
		);
	}

	@Override
	public String getName() {
		return "Acquire fried "+ingredientClass.getSimpleName();
	}
	
	protected static final Predicate<IItem> oilPredicate = new Predicate<IItem>() {
		@Override
		public boolean apply( IItem item ) {
			return item instanceof IOil;
		}
	};
}
