package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;

/** Abstract task
 * 
 * @author Paletz
 *
 * @param <Stage> stage enumerator
 */
public abstract class AbstractTask<Stage> implements ITask {

	protected EmohawkVilleChefBot<?> bot;
	protected ITask subTask;
	protected Stage stage;
	protected Stage successStage;
	protected Stage failureStage;
	
	/** Create a pick up an item task  
	 * 
	 * @param bot bot
	 * @param successStage final stage when task is successfully done
	 * @param failureStage final stage when task has failed
	 */
	public AbstractTask( EmohawkVilleChefBot<?> bot, Stage successStage, Stage failureStage ) {
		this.bot = bot;
		this.stage = null;
		this.successStage = successStage;
		this.failureStage = failureStage;
	}
	
	@Override
	public void logic() {
		updateStage();
		stageLogic();
	}
	
	@Override
	public boolean hasFinished() {
		updateStage();
		return isFinalStage( stage );
	}
	
	@Override
	public boolean hasFailed() {
		updateStage();
		return stage == failureStage;
	}
	
	@Override
	public boolean hasSucceded() {
		updateStage();
		return stage == successStage;
	}
	
	@Override
	public void abort() {
		clearSubTask();
	}
	
	@Override
	public ITask getSubTask() {
		updateStage();
		return subTask;
	}
	
	@Override
	public String toString() {
		updateStage();
		return getName()+"/"+stage.toString();
	}
	
	public abstract String getName();
	
	protected boolean isFinalStage( Stage stage ) {
		 return stage != null && ( stage == successStage || stage == failureStage );
	}
	
	protected void updateStage() {
	}
	
	protected void stageLogic() {
	}
	
	protected void clearSubTask() {
		if ( subTask != null ) {
			subTask.abort();
			subTask = null;
		}
	}
	
	protected void clearIncorrectSubtask( ITask correctTask ) {
		clearIncorrectSubtask( correctTask, false );
	}
	
	protected void clearIncorrectSubtask( ITask expectedTask, boolean force ) {
		if (
			subTask != expectedTask
			||
			subTask == null
			||
			subTask.hasFinished()
			||
			force
		) {
			clearSubTask();
		}
	}
}
