package cz.cuni.amis.pogamut.emohawk.examples.chefbot;

import java.util.ArrayList;
import java.util.List;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

public class Kitchen {
	protected IWorldView worldView;
	protected String mapName;
	
	protected Location center;
	protected double radius;
	protected List<NavPoint> navPoints;
	
	public Kitchen( IWorldView worldView, String mapName, int kitchenIndex ) {
		this.worldView = worldView;
		this.mapName = mapName;
		
		navPoints = new ArrayList<NavPoint>();
		
		if ( "EV-EmohawkVille_v06b".equalsIgnoreCase( mapName ) ) {
			initEmohawkUdk06b();
		} else if ( "EV-HellsKitchen_v02".equalsIgnoreCase( mapName ) ) {
			initHellsKitchen( kitchenIndex );
		} else {
			throw new RuntimeException( "Unknown map "+mapName+"." );
		}
	}
	
	public List<NavPoint> getNavPoints() {
		return navPoints;
	}
	
	public Location getCenter() {
		return center;
	}
	
	public double getRadius() {
		return radius;
	}
	
	public boolean isWithin( ILocated located ) {
		return center.getDistance2D( located.getLocation() ) < radius;
	}
	
	protected void initEmohawkUdk06b() {
		center = new Location( 750, -1875, 65 );
		radius = 1024;
		navPoints.add( getNav("PathNode_10") );
		navPoints.add( getNav("PathNode_17") );
		navPoints.add( getNav("PathNode_64") );
		navPoints.add( getNav("PathNode_294") );
		navPoints.add( getNav("PathNode_544") );
		navPoints.add( getNav("PathNode_545") );
		navPoints.add( getNav("PathNode_552") );
		navPoints.add( getNav("PathNode_546") );
		navPoints.add( getNav("PathNode_547") );
		navPoints.add( getNav("PathNode_548") );
		navPoints.add( getNav("PathNode_549") );
		navPoints.add( getNav("PathNode_550") );
		navPoints.add( getNav("PathNode_551") );
	}
	
	
	protected void initHellsKitchen( int kitchenIndex ) {
		radius = 640;
		
		if ( 0 <= kitchenIndex && kitchenIndex < 4 ) {
			center = new Location( 1536-kitchenIndex*1024, 1536, 50 );
		} else if ( kitchenIndex < 8 ) {
			center = new Location( 1536-(kitchenIndex-4)*1024, -1536, 50 );
		} else {
			throw new RuntimeException( "Invalid kitchen index." );
		}
				
		for ( NavPoint navPoint : worldView.getAll( NavPoint.class ).values() ) {
			if ( isWithin( navPoint ) ) {
				navPoints.add( navPoint );
			}
		}
	}
	
	protected NavPoint getNav( String name ) {
		NavPoint retval = worldView.getAll( NavPoint.class ).get( WorldObjectId.get( name ) );
		assert( retval!=null );
		return retval;
	}
}
