package cz.cuni.amis.pogamut.emohawk.examples.chefbot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;

import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CreateServedFoodTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CreateServedFoodTask.IngredientState;
import cz.cuni.amis.pogamut.emohawk.factory.guice.remoteagent.EmohawkBotModule;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.PawnReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.action.ActionRegistryReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.ISalt;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.meat.IBeef;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable.IPotato;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable.ITomatoSlice;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.vegetable.IYellowPepperSlice;
import cz.cuni.amis.pogamut.emohawkVille.bot.impl.EmohawkVilleBotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.params.UT2004BotParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointNeighbourLink;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.UT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

/**
 * Pogamut's "Hello essenceMap!" example showing few extra things such as introspection
 * and various bot-initializing methods.
 * <p><p>
 * First, try to run the bot and kill it... than uncomment the line inside {@link EmohawkVilleChefBot#botKilled(BotKilled)} 
 * and run the bot again kill it to see the difference. 
 *
 * @author Michal Bida aka Knight
 * @author Rudolf Kadlec aka ik
 * @author Jakub Gemrot aka Jimmy
 */
@AgentScoped
public class EmohawkVilleChefBot<Bot extends UT2004Bot<?,?,?>> extends EmohawkVilleBotController<Bot> {

	protected ITask task = null;
	protected Kitchen kitchen;
		
    /**
     * Initialize all necessary variables here, before the bot actually receives anything
     * from the environment.
     */
    @Override
    public void prepareBot(Bot bot) {
    }
    
    /**
     * Here we can modify initializing command for our bot, e.g., sets its name or skin.
     * @return instance of {@link Initialize}
     */
    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("ChefBot");
    }
    
    /**
     * Handshake with GameBots2004 is over - bot has information about the map in its essenceMap view.
     * Many agent modules are usable since this method is called.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     */
    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    	navBuilder.setAutoPrefix( false );
    	for ( NavPoint navPoint : world.getAll( NavPoint.class ).values() ) {
    		Collection<NavPointNeighbourLink> links = new ArrayList<NavPointNeighbourLink>();
    		links.addAll( navPoint.getOutgoingEdges().values() );
    		for ( NavPointNeighbourLink edge : links ) {
    			if ( edge.getFlags() != 1 ) {
    				navBuilder.removeEdge( navPoint.getId().getStringId(), edge.getToNavPoint().getId().getStringId() );
    			}
    		}
    	}
    	fwMap.refreshPathMatrix();
    	kitchen = new Kitchen( world, getGame().getMapName(), new Random().nextInt(8) );
    }

    /**
     * The bot is initilized in the environment - a physical representation of the bot is present in the game.
     * @param gameInfo informaton about the game type
     * @param config information about configuration
     * @param init information about configuration
     * @param self information about the agent
     */
    @Override
    public void botFirstSpawn(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
    	task = (
    		new CreateServedFoodTask( this )
    		.orderIngredient( IPotato.class, IngredientState.BOILED, 0.140f )
    		.orderIngredient( IBeef.class, IngredientState.FRIED, 0.200f )
    		.orderIngredient( ITomatoSlice.class, IngredientState.PLAIN, 0.100f )
    		.orderIngredient( IYellowPepperSlice.class, IngredientState.PLAIN, 0.050f )
    		.orderIngredient( ISalt.class, IngredientState.PLAIN, 0.001f )
    	);
    }
    
    /**
     * This method is called only once right before actual logic() method is called for the first time.
     */
    @Override
    public void beforeFirstLogic() {
    }

    /**
     * Main method that controls the bot - makes decisions what to do next.
     * It is called iteratively by Pogamut engine every time a synchronous batch
     * from the environment is received. This is usually 4 times per second - it
     * is affected by visionTime variable, that can be adjusted in GameBots ini file in
     * UT2004/System folder.
     *
     * @throws cz.cuni.amis.pogamut.base.exceptions.PogamutException
     */
    @Override
    public void logic() throws PogamutException {
    	if ( task != null ) {
			String taskStructure = "";
			ITask taskPointer = task;
			while ( taskPointer != null ) {
				taskStructure += " -> "+taskPointer.toString();
				taskPointer = taskPointer.getSubTask();
			}
			System.out.println( taskStructure );
			
			if ( task.hasFinished() ) {
    			task = null;
    		} else {
    			task.logic();
    		}
    	} else {
    		System.out.println( "No task." );
    	}
    }
    
    /**
     * Called each time the bot dies. Good for reseting all bot's state dependent variables.
     *
     * @param event
     */
    @Override
    public void botKilled(BotKilled event) {
    }
    
    public PawnReplica getPawn() {
    	return getEssenceMap().retrievePawn( bot.getSelf() );
    }
    
    public ActionRegistryReplica getActionRegistry() {
    	return getEssenceMap().retrieveActionRegistry();
    }
    
	public Kitchen getKitchen() {
		return kitchen;
	}
    
    /**
     * This method is called when the bot is started either from IDE or from command line.
     *
     * @param args
     */
    public static void main(String args[]) throws PogamutException {
    	// wrapped logic for bots executions, suitable to run single bot in single JVM
    	@SuppressWarnings({ "rawtypes", "unchecked" })
		EmohawkBotModule<UT2004BotParameters> botModule = new EmohawkBotModule( EmohawkVilleChefBot.class );
    	new UT2004BotRunner<UT2004Bot<?,?,?>,UT2004BotParameters>( botModule, "EmohawkVilleChefBot").setHost("localhost").setPort(3000).setMain(true).startAgent();
    }
}
