/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;

public class TimedTask
extends AbstractTask<Stage> {
    protected double maxDuration;
    protected double startTime;

    public TimedTask(EmohawkVilleChefBot<?> bot, double maxDuration, ITask task) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.maxDuration = maxDuration;
        this.subTask = task;
        this.startTime = bot.getInfo().getTime();
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.subTask.hasSucceded()) {
            this.stage = Stage.DONE;
            return;
        }
        if (this.subTask.hasFailed()) {
            this.stage = Stage.FAILED;
            return;
        }
        if (this.bot.getInfo().getTime() > this.startTime + this.maxDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        this.stage = Stage.DO;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case DO: {
                this.subTask.logic();
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
            }
        }
    }

    @Override
    public String getName() {
        return "Time";
    }

    protected static enum Stage {
        DO,
        DONE,
        FAILED;

    }
}

