/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IPossessor;

public class TakeFromContainerTask
extends AbstractTask<Stage> {
    protected double searchDuration;
    protected int containerGameObjectId;
    protected int itemGameObjectId;
    protected GoToTask goToTask;

    public TakeFromContainerTask(EmohawkVilleChefBot<?> bot, IContainer container, IItem item, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.searchDuration = searchDuration;
        this.containerGameObjectId = container.getGameObjectId();
        this.itemGameObjectId = item.getGameObjectId();
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.findWantedItem((IPossessor)this.bot.getPawn()) != null) {
            this.stage = Stage.DONE;
            return;
        }
        IContainerMemorization<?> container = this.findContainerInMemory();
        if (container == null || this.bot.getInfo().getTime() - container.getMemorizationEpochTime() > this.searchDuration || this.findWantedItem((IPossessor)container) == null) {
            this.stage = Stage.FAILED;
            return;
        }
        this.bot.getObservationMemory().setImportance(container, 16.0);
        this.stage = this.bot.getInfo().getDistance((ILocated)container.getActorLocation()) < (double)this.bot.getActionRegistry().getTakeItemFromContainerAction().getRange() * 0.9 ? (container.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime() ? Stage.TAKE : Stage.SEARCH) : Stage.MOVE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    this.goToTask = new GoToTask(this.bot, this.findContainerInMemory().getActorLocation(), (double)this.bot.getActionRegistry().getTakeItemFromContainerAction().getRange() * 0.9);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.findContainerInMemory().getActorLocation());
                break;
            }
            case TAKE: {
                this.clearSubTask();
                IContainerMemorization<?> container = this.findContainerInMemory();
                IContainerReplica containerReplica = (IContainerReplica)this.bot.getObservationMemory().getPreimage(container);
                IItemReplica itemReplica = (IItemReplica)this.findWantedItem((IPossessor)containerReplica);
                this.bot.getActionRegistry().getTakeItemFromContainerAction().request((ICollectorReplica)this.bot.getPawn(), containerReplica, itemReplica, (IActionResultHandler)new ActionErrorPrinter("Pick up " + itemReplica.getDisplayName()));
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected stage: " + this.stage));
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
    }

    @Override
    public String getName() {
        return "TakeFromContainer";
    }

    protected IItem findWantedItem(IPossessor possessor) {
        for (IItem item : possessor.readInventory()) {
            if (item.getGameObjectId() != this.itemGameObjectId) continue;
            return item;
        }
        return null;
    }

    protected IContainerMemorization<?> findContainerInMemory() {
        for (IContainerMemorization container : this.bot.getObservationMemory().getAllByMemorization(IContainerMemorization.class)) {
            if (container.getGameObjectId() != this.containerGameObjectId) continue;
            return container;
        }
        return null;
    }

    protected static enum Stage {
        INIT,
        MOVE,
        SEARCH,
        TAKE,
        DONE,
        FAILED;

    }
}

