/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.IEssenceMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.StovePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.ICookwareMemorization;
import java.util.ArrayList;

public class StoreInContainerTask
extends AbstractTask<Stage> {
    protected double searchDuration;
    protected int containerGameObjectId;
    protected int itemGameObjectId;
    protected GoToTask goToTask;

    public StoreInContainerTask(EmohawkVilleChefBot<?> bot, IContainer container, IItem item, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.searchDuration = searchDuration;
        this.containerGameObjectId = container.getGameObjectId();
        this.itemGameObjectId = item.getGameObjectId();
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.findItemInInventory() == null) {
            this.stage = Stage.DONE;
            return;
        }
        IContainerMemorization<?> container = this.findContainerInMemory();
        if (container == null || this.bot.getInfo().getTime() - container.getMemorizationEpochTime() > this.searchDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        if (container.getActorLocation() != null) {
            this.bot.getObservationMemory().setImportance(container, 16.0);
        } else {
            this.bot.getObservationMemory().setImportance((IEssenceMemorization)((ICookwareMemorization)container).getOwnerPossessor(), 16.0);
        }
        Location containerLocation = container.getActorLocation();
        if (containerLocation == null) {
            containerLocation = ((IItem)container).getOwnerPossessor().getActorLocation();
        }
        this.stage = this.bot.getInfo().getDistance((ILocated)containerLocation) < (double)this.bot.getActionRegistry().getStoreItemInContainerAction().getRange() * 0.9 ? (container.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime() ? Stage.STORE : Stage.SEARCH) : Stage.MOVE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    IContainerMemorization<?> container = this.findContainerInMemory();
                    Location containerLocation = container.getActorLocation();
                    if (containerLocation == null) {
                        containerLocation = ((IItem)container).getOwnerPossessor().getActorLocation();
                    }
                    this.goToTask = new GoToTask(this.bot, containerLocation, (double)this.bot.getActionRegistry().getStoreItemInContainerAction().getRange() * 0.9);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.getEffectiveContainerLocation((IContainer)this.findContainerInMemory()));
                break;
            }
            case STORE: {
                this.clearSubTask();
                IContainerMemorization<?> container = this.findContainerInMemory();
                IContainerReplica containerReplica = (IContainerReplica)this.bot.getObservationMemory().getPreimage(container);
                IItemReplica itemReplica = this.findItemInInventory();
                this.bot.getActionRegistry().getStoreItemInContainerAction().request((ICollectorReplica)this.bot.getPawn(), containerReplica, itemReplica, (IActionResultHandler)new ActionErrorPrinter("Store " + itemReplica.getDisplayName()));
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected stage: " + this.stage));
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
    }

    @Override
    public String getName() {
        return "Store in container";
    }

    protected IItemReplica findItemInInventory() {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (item.getGameObjectId() != this.itemGameObjectId) continue;
            return item;
        }
        return null;
    }

    protected IContainerMemorization<?> findContainerInMemory() {
        ArrayList<IContainerMemorization> candidates = new ArrayList<IContainerMemorization>();
        for (StovePlateMemorization stovePlate : this.bot.getObservationMemory().getAllByMemorization(StovePlateMemorization.class)) {
            if (!this.bot.getKitchen().isWithin((ILocated)stovePlate.getActorLocation())) continue;
            for (IItemMemorization item : stovePlate.readInventory()) {
                candidates.add((IContainerMemorization)item);
            }
        }
        for (IContainerMemorization container : this.bot.getObservationMemory().getAllByMemorization(IContainerMemorization.class)) {
            if (!this.bot.getKitchen().isWithin((ILocated)container.getActorLocation())) continue;
            candidates.add(container);
        }
        for (IContainerMemorization container : candidates) {
            if (container.getGameObjectId() != this.containerGameObjectId) continue;
            return container;
        }
        return null;
    }

    protected Location getEffectiveContainerLocation(IContainer container) {
        Location retval = container.getActorLocation();
        if (retval == null) {
            retval = this.getEffectiveContainerLocation((IContainer)((IItem)container).getOwnerPossessor());
        }
        return retval;
    }

    protected static enum Stage {
        MOVE,
        SEARCH,
        STORE,
        DONE,
        FAILED;

    }
}

