/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.IEssenceMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CollectTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.DishwarePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredientReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.DishwarePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IDishwarePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IScoop;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ITurner;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookwareReplica;

public class ServeIngredientTask
extends AbstractTask<Stage> {
    protected double searchDuration;
    protected int dishwarePlateGameObjectId;
    protected int ingredientGameObjectId;
    protected GoToTask goToTask;
    protected CollectTask collectScoopTask;
    protected CollectTask collectTurnerTask;
    protected final Predicate<IItem> scoopPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof IScoop;
        }
    };
    protected final Predicate<IItem> turnerPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof ITurner;
        }
    };

    public ServeIngredientTask(EmohawkVilleChefBot<?> bot, IDishwarePlate dishwarePlate, IIngredient ingredient, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.searchDuration = searchDuration;
        this.dishwarePlateGameObjectId = dishwarePlate.getGameObjectId();
        this.ingredientGameObjectId = ingredient.getGameObjectId();
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.findIngredientInInventory() == null) {
            this.stage = Stage.DONE;
            return;
        }
        boolean hasScoop = false;
        boolean hasTurner = false;
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (this.scoopPredicate.apply((Object)item)) {
                hasScoop = true;
            }
            if (!this.turnerPredicate.apply((Object)item)) continue;
            hasTurner = true;
        }
        if (!hasScoop) {
            this.stage = Stage.COLLECT_SCOOP;
            return;
        }
        if (!hasTurner) {
            this.stage = Stage.COLLECT_TURNER;
            return;
        }
        DishwarePlateMemorization plate = this.findPlateInMemory();
        if (plate == null || this.bot.getInfo().getTime() - plate.getMemorizationEpochTime() > this.searchDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        this.bot.getObservationMemory().setImportance((IEssenceMemorization)plate, 16.0);
        this.stage = this.bot.getInfo().getDistance((ILocated)plate.getActorLocation()) < (double)this.bot.getActionRegistry().getTakeItemFromContainerAction().getRange() * 0.9 ? (plate.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime() ? Stage.SERVE : Stage.SEARCH) : Stage.MOVE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case COLLECT_SCOOP: {
                this.clearIncorrectSubtask(this.collectScoopTask);
                if (this.subTask == null) {
                    this.collectScoopTask = new CollectTask(this.bot, this.scoopPredicate);
                    this.subTask = this.collectScoopTask;
                }
                this.subTask.logic();
                break;
            }
            case COLLECT_TURNER: {
                this.clearIncorrectSubtask(this.collectTurnerTask);
                if (this.subTask == null) {
                    this.collectTurnerTask = new CollectTask(this.bot, this.turnerPredicate);
                    this.subTask = this.collectTurnerTask;
                }
                this.subTask.logic();
                break;
            }
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    this.goToTask = new GoToTask(this.bot, this.findPlateInMemory().getActorLocation(), (double)this.bot.getActionRegistry().getStoreItemInContainerAction().getRange() * 0.9);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.findPlateInMemory().getActorLocation());
                break;
            }
            case SERVE: {
                this.clearSubTask();
                DishwarePlateMemorization plateMemorization = this.findPlateInMemory();
                DishwarePlateReplica plateReplica = (DishwarePlateReplica)this.bot.getObservationMemory().getPreimage((IObjectMemorization)plateMemorization);
                IIngredientReplica ingredientReplica = this.findIngredientInInventory();
                this.bot.getActionRegistry().getServeFoodAction().request(this.bot.getPawn(), ingredientReplica, plateReplica, (IActionResultHandler)new ActionErrorPrinter("Serve " + ingredientReplica.getDisplayName()));
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected stage: " + this.stage));
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
        this.collectScoopTask = null;
        this.collectTurnerTask = null;
    }

    @Override
    public String getName() {
        return "Serve";
    }

    protected IIngredientReplica findIngredientInInventory() {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (!(item instanceof ICookwareReplica)) continue;
            ICookwareReplica cookware = (ICookwareReplica)item;
            for (IIngredientReplica ingredient : cookware.readIngredients()) {
                if (ingredient.getGameObjectId() != this.ingredientGameObjectId) continue;
                return ingredient;
            }
        }
        return null;
    }

    protected DishwarePlateMemorization findPlateInMemory() {
        for (DishwarePlateMemorization plate : this.bot.getObservationMemory().getAllByMemorization(DishwarePlateMemorization.class)) {
            if (plate.getGameObjectId() != this.dishwarePlateGameObjectId) continue;
            return plate;
        }
        return null;
    }

    protected static enum Stage {
        COLLECT_SCOOP,
        COLLECT_TURNER,
        MOVE,
        SEARCH,
        SERVE,
        DONE,
        FAILED;

    }
}

