/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Supplier;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.LookAroundTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.TimedTask;
import java.util.List;
import java.util.Random;

public class SearchTask
extends AbstractTask<Stage> {
    protected static final double LOOK_AROUND_DURATION = 2.0;
    protected List<? extends ILocated> locations;
    protected Supplier<Boolean> hasFound;
    protected GoToTask goToTask;
    protected ITask lookAroundTask;

    public SearchTask(EmohawkVilleChefBot<?> bot, List<? extends ILocated> locations, Supplier<Boolean> hasFound) {
        super(bot, Stage.DONE, null);
        this.locations = locations;
        this.hasFound = hasFound;
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (((Boolean)this.hasFound.get()).booleanValue()) {
            this.stage = Stage.DONE;
            return;
        }
        if (this.stage == null) {
            this.stage = Stage.LOOK;
            return;
        }
        if (this.subTask instanceof GoToTask && this.subTask.hasFinished()) {
            this.stage = Stage.LOOK;
            return;
        }
        if (this.subTask instanceof TimedTask && this.subTask.hasFinished() && this.locations.size() > 0) {
            this.stage = Stage.MOVE;
            return;
        }
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    Location destination = this.locations.get(new Random().nextInt(this.locations.size())).getLocation();
                    this.goToTask = new GoToTask(this.bot, destination.getLocation(), 50.0);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case LOOK: {
                this.clearIncorrectSubtask(this.lookAroundTask);
                if (this.subTask == null) {
                    this.lookAroundTask = new LookAroundTask(this.bot);
                    if (this.locations.size() > 0) {
                        this.lookAroundTask = new TimedTask(this.bot, 2.0, this.lookAroundTask);
                    }
                    this.subTask = this.lookAroundTask;
                }
                this.subTask.logic();
                break;
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
        this.lookAroundTask = null;
    }

    @Override
    public String getName() {
        return "Search";
    }

    protected static enum Stage {
        MOVE,
        LOOK,
        DONE;

    }
}

