/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;

public class PickUpTask
extends AbstractTask<Stage> {
    protected double searchDuration;
    protected int itemGameObjectId;
    protected GoToTask goToTask;

    public PickUpTask(EmohawkVilleChefBot<?> bot, IItem item, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.searchDuration = searchDuration;
        this.itemGameObjectId = item.getGameObjectId();
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.isPossessed()) {
            this.stage = Stage.DONE;
            return;
        }
        IItemMemorization<?> item = this.findItemInMemory();
        if (item == null || this.bot.getInfo().getTime() - item.getMemorizationEpochTime() > this.searchDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        this.bot.getObservationMemory().setImportance(item, 16.0);
        if (this.bot.getInfo().getDistance((ILocated)item.getActorLocation()) < (double)this.bot.getActionRegistry().getPickUpItemAction().getRange() * 0.9) {
            this.stage = item.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime() ? Stage.PICK : Stage.SEARCH;
            return;
        }
        this.stage = Stage.MOVE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    this.goToTask = new GoToTask(this.bot, this.findItemInMemory().getActorLocation(), (double)this.bot.getActionRegistry().getPickUpItemAction().getRange() * 0.9);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.findItemInMemory().getActorLocation());
                break;
            }
            case PICK: {
                this.clearSubTask();
                IItemMemorization<?> itemMemorization = this.findItemInMemory();
                IItemReplica itemReplica = (IItemReplica)this.bot.getObservationMemory().getPreimage(itemMemorization);
                this.bot.getActionRegistry().getPickUpItemAction().request((ICollectorReplica)this.bot.getPawn(), itemReplica, (IActionResultHandler)new ActionErrorPrinter("Pick up " + itemReplica.getDisplayName()));
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected stage: " + this.stage));
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
    }

    protected boolean isPossessed() {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (item.getGameObjectId() != this.itemGameObjectId) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Pick up";
    }

    protected IItemMemorization<?> findItemInMemory() {
        for (IItemMemorization item : this.bot.getObservationMemory().getAllByMemorization(IItemMemorization.class)) {
            if (item.getGameObjectId() != this.itemGameObjectId) continue;
            return item;
        }
        return null;
    }

    protected static enum Stage {
        MOVE,
        SEARCH,
        PICK,
        DONE,
        FAILED;

    }
}

