/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;

public class GoToTask
extends AbstractTask<Stage> {
    protected Location destination;
    protected double destinationReachedDistance;

    public GoToTask(EmohawkVilleChefBot<?> bot, Location destination, double destinationReachedDistance) {
        super(bot, Stage.DONE, null);
        this.destination = destination;
        this.destinationReachedDistance = destinationReachedDistance;
    }

    public Location getDestination() {
        return this.destination;
    }

    public double getDestinationReachedDistance() {
        return this.destinationReachedDistance;
    }

    @Override
    public void abort() {
        super.abort();
        this.bot.getPathExecutor().stop();
        this.bot.getMove().stopMovement();
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.bot.getInfo().getDistance((ILocated)this.destination) <= this.destinationReachedDistance) {
            this.stage = Stage.DONE;
            return;
        }
        if (this.bot.getNavigation().getNearestNavPoint((ILocated)this.bot.getInfo()) != this.bot.getNavigation().getNearestNavPoint((ILocated)this.destination)) {
            this.stage = Stage.MOVE_TO_NAVPOINT;
            return;
        }
        this.stage = Stage.MOVE_TO_LOCATION;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case DONE: {
                if (this.bot.getPathExecutor().isExecuting()) {
                    this.bot.getPathExecutor().stop();
                }
                if (!this.bot.getMove().isRunning()) break;
                this.bot.getMove().stopMovement();
                break;
            }
            case MOVE_TO_LOCATION: {
                if (this.bot.getPathExecutor().isExecuting()) {
                    this.bot.getPathExecutor().stop();
                }
                this.bot.getMove().moveTo((ILocated)this.destination);
                break;
            }
            case MOVE_TO_NAVPOINT: {
                IUnrealPathExecutor pathExecutor = this.bot.getPathExecutor();
                if (pathExecutor.isTargetReached()) {
                    this.bot.getPathExecutor().stop();
                    this.bot.getMove().moveTo((ILocated)this.destination);
                    return;
                }
                if (pathExecutor.isStuck()) {
                    pathExecutor.stop();
                    this.bot.getMove().moveTo((ILocated)this.bot.getNavigation().getNearestNavPoint((ILocated)this.bot.getInfo().getLocation()));
                    return;
                }
                if (!pathExecutor.isExecuting()) {
                    IPathFuture path = this.bot.getFwMap().computePath(this.bot.getInfo().getNearestNavPoint(), this.bot.getNavigation().getNearestNavPoint((ILocated)this.destination));
                    pathExecutor.followPath(path);
                }
                assert (!pathExecutor.isPathUnavailable());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public String getName() {
        return "GoTo(" + this.destination + ")";
    }

    protected double getNavPointProximity(Location location) {
        return this.bot.getNavigation().getNearestNavPoint((ILocated)location).getLocation().getDistance(location);
    }

    protected static enum Stage {
        MOVE_TO_NAVPOINT,
        MOVE_TO_LOCATION,
        DONE;

    }
}

