/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractCookTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.FryingPanMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IFriableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredientReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ITurner;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.FryingPanReplica;

public class FryTask
extends AbstractCookTask {
    protected static final Predicate<IItem> turnerPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof ITurner;
        }
    };

    public FryTask(EmohawkVilleChefBot<?> bot, IStovePlate stovePlate, double searchDuration) {
        super(bot, stovePlate, searchDuration);
    }

    @Override
    protected Predicate<IItem> getToolPredicate() {
        return turnerPredicate;
    }

    @Override
    protected boolean isCooked(IIngredient ingredient) {
        if (ingredient instanceof IFriableIngredient) {
            IFriableIngredient friableIngredient = (IFriableIngredient)ingredient;
            return (double)friableIngredient.getBottomFriedness() == 1.0 && (double)friableIngredient.getTopFriedness() == 1.0;
        }
        return true;
    }

    @Override
    protected float getCookingRange() {
        return Math.min(this.bot.getActionRegistry().getSetStovePowerAction().getRange(), this.bot.getActionRegistry().getFlipIngredientsAction().getRange());
    }

    @Override
    protected float getMinCookingTemperature() {
        return 150.0f;
    }

    @Override
    protected float getMaxCookingTemperature() {
        return 180.0f;
    }

    @Override
    protected void cookingLogic() {
        FryingPanReplica cookware = (FryingPanReplica)this.bot.getObservationMemory().getPreimage((IObjectMemorization)this.findCookwareInMemory());
        for (IIngredientReplica ingredient : cookware.readIngredients()) {
            IFriableIngredient friableIngredient;
            if (!(ingredient instanceof IFriableIngredient) || !((friableIngredient = (IFriableIngredient)ingredient).getIsUpsideDown() ? (double)friableIngredient.getTopFriedness() < 1.0 : (double)friableIngredient.getBottomFriedness() < 1.0)) continue;
            return;
        }
        this.bot.getActionRegistry().getFlipIngredientsAction().request(this.bot.getPawn(), cookware, (IActionResultHandler)new ActionErrorPrinter("Flip"));
    }

    @Override
    protected int getTargetStovePower() {
        return 4;
    }

    @Override
    public String getName() {
        return "Fry";
    }

    protected FryingPanMemorization findCookwareInMemory() {
        return (FryingPanMemorization)super.findCookwareInMemory();
    }
}

