/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.action.trade.IBartererMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.IBartererReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.ITradeProcess;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.trade.TradeProcessReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.process.IExecutorReplica;

public class DemandTask
extends AbstractTask<Stage> {
    public static final double ASK_FOR_ITEM_PERIOD = 10.0;
    protected double searchDuration;
    protected int itemGameObjectId;
    protected double lastAskForItemTime;
    protected GoToTask goToTask;

    public DemandTask(EmohawkVilleChefBot<?> bot, IItem item, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.searchDuration = searchDuration;
        this.itemGameObjectId = item.getGameObjectId();
        this.lastAskForItemTime = -10.0;
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.isPossessed()) {
            this.stage = Stage.DONE;
            return;
        }
        IItemMemorization<?> item = this.findItemInMemory();
        if (item == null || this.bot.getInfo().getTime() - item.getMemorizationEpochTime() > this.searchDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        IBartererMemorization<?> barterer = this.findBartererInMemory();
        this.bot.getObservationMemory().setImportance(barterer, 16.0);
        if (this.bot.getInfo().getDistance((ILocated)barterer.getActorLocation()) < (double)this.bot.getActionRegistry().getTradeAction().getRange() * 0.9) {
            if (item.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime()) {
                if (this.bot.getPawn().getProcess() != null) {
                    ITradeProcess tradeProcess = null;
                    if (!(this.bot.getPawn().getProcess() instanceof ITradeProcess)) {
                        this.stage = Stage.OPEN_TRADE;
                        return;
                    }
                    tradeProcess = (ITradeProcess)this.bot.getPawn().getProcess();
                    if (tradeProcess != null && tradeProcess.getBarterPartner().getGameObjectId() == barterer.getGameObjectId()) {
                        if (tradeProcess.getBarterPartnerProcess() != null) {
                            for (IItem offeredItem : tradeProcess.getBarterPartnerProcess().readOffer()) {
                                if (offeredItem.getGameObjectId() != this.itemGameObjectId) continue;
                                this.stage = Stage.ACCEPT_TRADE;
                                return;
                            }
                        }
                        this.stage = Stage.ASK_FOR_ITEM;
                    } else {
                        this.stage = Stage.INTERRUPT_ACTION;
                    }
                } else {
                    this.stage = Stage.OPEN_TRADE;
                }
            } else {
                this.stage = Stage.SEARCH;
            }
        } else {
            this.stage = Stage.MOVE;
        }
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    this.goToTask = new GoToTask(this.bot, this.findBartererInMemory().getActorLocation(), (double)this.bot.getActionRegistry().getPickUpItemAction().getRange() * 0.9);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.findBartererInMemory().getActorLocation());
                break;
            }
            case INTERRUPT_ACTION: {
                this.clearSubTask();
                this.bot.getActionRegistry().getInterruptProcessAction().request((IExecutorReplica)this.bot.getPawn(), (IActionResultHandler)new ActionErrorPrinter("Interrupt action not matching intended trade"));
                break;
            }
            case OPEN_TRADE: {
                this.clearSubTask();
                this.bot.getActionRegistry().getTradeAction().request((IBartererReplica)this.bot.getPawn(), (IBartererReplica)this.bot.getObservationMemory().getPreimage(this.findBartererInMemory()), (IActionResultHandler)new ActionErrorPrinter(""));
                break;
            }
            case ASK_FOR_ITEM: {
                this.clearSubTask();
                IItemMemorization<?> wantedItem = this.findItemInMemory();
                int itemIndex = 0;
                for (IItemMemorization item : this.findBartererInMemory().readInventory()) {
                    ++itemIndex;
                    if (wantedItem != item) continue;
                    break;
                }
                if (!(this.lastAskForItemTime + 10.0 < this.bot.getInfo().getTime())) break;
                this.lastAskForItemTime = this.bot.getInfo().getTime();
                this.bot.getComm().sendGlobalTextMessage("Give me the " + this.findItemInMemory().getDisplayName() + ", it is the item number " + itemIndex + " in your inventory!");
                break;
            }
            case ACCEPT_TRADE: {
                this.clearSubTask();
                ((TradeProcessReplica)this.bot.getPawn().getProcess()).sendHasAccepted(true);
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected stage: " + this.stage));
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
    }

    protected boolean isPossessed() {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (item.getGameObjectId() != this.itemGameObjectId) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Demand";
    }

    protected IBartererMemorization<?> findBartererInMemory() {
        return (IBartererMemorization)this.findItemInMemory().getOwnerPossessor();
    }

    protected IItemMemorization<?> findItemInMemory() {
        for (IBartererMemorization barterer : this.bot.getObservationMemory().getAllByMemorization(IBartererMemorization.class)) {
            for (IItemMemorization item : barterer.readInventory()) {
                if (item.getGameObjectId() != this.itemGameObjectId) continue;
                return item;
            }
        }
        return null;
    }

    protected static enum Stage {
        MOVE,
        SEARCH,
        FAILED,
        INTERRUPT_ACTION,
        OPEN_TRADE,
        ASK_FOR_ITEM,
        ACCEPT_TRADE,
        DONE;

    }
}

