/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AcquireBoiledIngredientTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AcquireFriedIngredientTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AcquirePieceItem;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CollectTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.PieceItemType;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ServeIngredientTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.StoreInContainerTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.DishwarePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IBoilableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IFriableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredientReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IDishwarePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookwareReplica;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateServedFoodTask
extends AbstractTask<Stage> {
    protected List<IngredientOrder> orders = new ArrayList<IngredientOrder>();
    protected ITask acquireOrderIngredientTask;
    protected ITask serveIngredientTask;
    protected IngredientOrder currentTaskOrder;
    protected DishwarePlateMemorization servedPlate;

    public CreateServedFoodTask(EmohawkVilleChefBot<?> bot) {
        super(bot, Stage.DONE, null);
    }

    @Override
    public String getName() {
        return "Create served food";
    }

    public CreateServedFoodTask orderIngredient(Class<? extends IIngredient> ingredientClass, IngredientState state, float volume) {
        IngredientOrder order = new IngredientOrder();
        order.ingredientClass = ingredientClass;
        order.state = state;
        order.volume = volume;
        this.orders.add(order);
        return this;
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        DishwarePlateMemorization dishwarePlate = this.findDishwarePlateInMemory();
        if (dishwarePlate != null && this.computeProgressRating(this.computeProgress(dishwarePlate.readIngredients())) >= (float)this.orders.size()) {
            this.stage = Stage.DONE;
            return;
        }
        IngredientOrder orderToServe = this.findOrderToServe();
        IIngredientReplica ingredient = this.findIngredientInInventory(orderToServe);
        this.stage = ingredient != null ? Stage.SERVE_INGREDIENT : Stage.CREATE_INGREDIENT;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case CREATE_INGREDIENT: {
                this.clearIncorrectSubtask(this.acquireOrderIngredientTask, this.currentTaskOrder != this.findOrderToServe());
                if (this.subTask == null) {
                    this.currentTaskOrder = this.findOrderToServe();
                    switch (this.currentTaskOrder.state) {
                        case BOILED: {
                            this.acquireOrderIngredientTask = new AcquireBoiledIngredientTask((EmohawkVilleChefBot<?>)this.bot, this.currentTaskOrder.getBoilableIngredientClass(), (double)this.currentTaskOrder.volume);
                            break;
                        }
                        case FRIED: {
                            this.acquireOrderIngredientTask = new AcquireFriedIngredientTask((EmohawkVilleChefBot<?>)this.bot, this.currentTaskOrder.getFriableIngredientClass(), (double)this.currentTaskOrder.volume);
                            break;
                        }
                        case PLAIN: {
                            PieceItemType pieceItemType = PieceItemType.classToType(this.currentTaskOrder.ingredientClass);
                            if (pieceItemType != null) {
                                this.acquireOrderIngredientTask = new AcquirePieceItem(this.bot, pieceItemType, 1);
                                break;
                            }
                            this.acquireOrderIngredientTask = new CollectTask(this.bot, this.currentTaskOrder);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)"Unexpected state.");
                        }
                    }
                    this.subTask = this.acquireOrderIngredientTask;
                }
                this.subTask.logic();
                break;
            }
            case SERVE_INGREDIENT: {
                IIngredientReplica ingredientToServe = this.findIngredientInInventory(this.findOrderToServe());
                boolean shouldBeStoreTask = ingredientToServe.getOwnerPossessor() == this.bot.getPawn();
                boolean shouldBeServeTask = !shouldBeStoreTask;
                this.clearIncorrectSubtask(this.serveIngredientTask, this.currentTaskOrder != this.findOrderToServe() || this.servedPlate == null || this.findDishwarePlateInMemory().getGameObjectId() != this.servedPlate.getGameObjectId() || shouldBeStoreTask && !(this.serveIngredientTask instanceof StoreInContainerTask) || shouldBeServeTask && !(this.serveIngredientTask instanceof ServeIngredientTask));
                if (this.subTask == null) {
                    this.servedPlate = this.findDishwarePlateInMemory();
                    this.currentTaskOrder = this.findOrderToServe();
                    this.serveIngredientTask = shouldBeStoreTask ? new StoreInContainerTask(this.bot, (IContainer)this.servedPlate, (IItem)ingredientToServe, Double.POSITIVE_INFINITY) : new ServeIngredientTask(this.bot, (IDishwarePlate)this.servedPlate, (IIngredient)ingredientToServe, Double.POSITIVE_INFINITY);
                    this.subTask = this.serveIngredientTask;
                }
                this.subTask.logic();
                break;
            }
            case DONE: {
                this.clearSubTask();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected stage " + this.stage + "."));
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.acquireOrderIngredientTask = null;
        this.serveIngredientTask = null;
    }

    protected IngredientOrder findOrderToServe() {
        DishwarePlateMemorization dishwarePlate = this.findDishwarePlateInMemory();
        if (dishwarePlate != null) {
            Map<IngredientOrder, Float> progress = this.computeProgress(dishwarePlate.readIngredients());
            for (IngredientOrder order : this.orders) {
                if (!(order.volume > progress.get(order).floatValue())) continue;
                return order;
            }
        }
        return this.orders.get(0);
    }

    protected IIngredientReplica findIngredientInInventory(IngredientOrder order) {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            IIngredientReplica ingredient;
            if (item instanceof ICookwareReplica) {
                ICookwareReplica cookware = (ICookwareReplica)item;
                for (IIngredientReplica ingredient2 : cookware.readIngredients()) {
                    if (!order.apply((IItem)ingredient2)) continue;
                    return ingredient2;
                }
            }
            if (!(item instanceof IIngredient) || !order.apply((IItem)(ingredient = (IIngredientReplica)item))) continue;
            return ingredient;
        }
        return null;
    }

    protected DishwarePlateMemorization findDishwarePlateInMemory() {
        DishwarePlateMemorization bestPlate = null;
        double bestPlateMemorizationTime = Double.NEGATIVE_INFINITY;
        double bestPlateProgressRating = 0.0;
        for (DishwarePlateMemorization plate : this.bot.getObservationMemory().getAllByMemorization(DishwarePlateMemorization.class)) {
            float progressRating;
            if (!this.bot.getKitchen().isWithin((ILocated)plate.getActorLocation()) || !((double)(progressRating = this.computeProgressRating(this.computeProgress(plate.readIngredients()))) > bestPlateProgressRating) && ((double)progressRating != bestPlateProgressRating || !(plate.getMemorizationEpochTime() > bestPlateMemorizationTime))) continue;
            bestPlate = plate;
            bestPlateMemorizationTime = plate.getMemorizationEpochTime();
            bestPlateProgressRating = progressRating;
        }
        return bestPlate;
    }

    protected float computeProgressRating(Map<IngredientOrder, Float> plateProgressMap) {
        float progressRating = 0.0f;
        for (Map.Entry<IngredientOrder, Float> entry : plateProgressMap.entrySet()) {
            progressRating += Math.min(1.0f, entry.getValue().floatValue() / entry.getKey().volume);
        }
        return progressRating;
    }

    protected Map<IngredientOrder, Float> computeProgress(Collection<? extends IIngredient> ingredients) {
        HashMap<IngredientOrder, Float> progressMap = new HashMap<IngredientOrder, Float>();
        for (IngredientOrder ingredientOrder : this.orders) {
            progressMap.put(ingredientOrder, Float.valueOf(0.0f));
        }
        block1: for (IIngredient iIngredient : ingredients) {
            for (IngredientOrder order : this.orders) {
                if (!order.apply((IItem)iIngredient) || !((double)((Float)progressMap.get(order)).floatValue() < 1.0)) continue;
                progressMap.put(order, Float.valueOf(((Float)progressMap.get(order)).floatValue() + iIngredient.getVolume()));
                continue block1;
            }
        }
        return progressMap;
    }

    protected class IngredientOrder
    implements Predicate<IItem> {
        public Class<? extends IIngredient> ingredientClass;
        public IngredientState state;
        public float volume;

        protected IngredientOrder() {
        }

        public boolean apply(IItem item) {
            if (!this.ingredientClass.isInstance(item)) {
                return false;
            }
            switch (this.state) {
                case BOILED: {
                    return (double)((IBoilableIngredient)item).getBoiledness() == 1.0;
                }
                case FRIED: {
                    return (double)((IFriableIngredient)item).getBottomFriedness() == 1.0 && (double)((IFriableIngredient)item).getTopFriedness() == 1.0;
                }
                case PLAIN: {
                    return true;
                }
            }
            throw new AssertionError((Object)"Unexpected state.");
        }

        public Class<? extends IBoilableIngredient> getBoilableIngredientClass() {
            assert (this.state == IngredientState.BOILED);
            Class<? extends IIngredient> retval = this.ingredientClass;
            return retval;
        }

        public Class<? extends IFriableIngredient> getFriableIngredientClass() {
            assert (this.state == IngredientState.FRIED);
            Class<? extends IIngredient> retval = this.ingredientClass;
            return retval;
        }
    }

    protected static enum Stage {
        CREATE_INGREDIENT,
        SERVE_INGREDIENT,
        DONE;

    }

    public static enum IngredientState {
        PLAIN,
        BOILED,
        FRIED;

    }
}

