/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.DemandTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.PickUpTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.SearchTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.TakeFromContainerTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.action.trade.IBartererMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import java.util.ArrayList;
import java.util.Collection;

public class CollectTask
extends AbstractTask<Stage> {
    protected Predicate<IItem> itemPredicate;
    protected int initialPossessedMatchingItemCount;
    protected SearchTask searchTask;
    protected PickUpTask pickUpTask;
    protected TakeFromContainerTask takeFromContainerTask;
    protected DemandTask demandTask;

    public CollectTask(EmohawkVilleChefBot<?> bot, Predicate<IItem> itemPredicate) {
        super(bot, Stage.DONE, null);
        this.itemPredicate = itemPredicate;
        this.initialPossessedMatchingItemCount = this.countPossessed();
    }

    public static IItemMemorization<?> findItemInMemory(EmohawkVilleChefBot<?> bot, Predicate<IItem> itemPredicate) {
        ArrayList<IItemMemorization> candidates = new ArrayList<IItemMemorization>();
        for (IItemMemorization item : bot.getObservationMemory().getAllByMemorization(IItemMemorization.class)) {
            if (!bot.getKitchen().isWithin((ILocated)item.getActorLocation()) || !bot.getPawn().canPickUp((IItem)item)) continue;
            candidates.add(item);
        }
        for (IContainerMemorization container : bot.getObservationMemory().getAllByMemorization(IContainerMemorization.class)) {
            if (!bot.getKitchen().isWithin((ILocated)container.getActorLocation())) continue;
            for (IItemMemorization item : container.readInventory()) {
                if (!container.canRelease((IItem)item)) continue;
                candidates.add(item);
            }
        }
        for (IBartererMemorization barterer : bot.getObservationMemory().getAllByMemorization(IBartererMemorization.class)) {
            if (barterer.getGameObjectId() == bot.getPawn().getGameObjectId() || !bot.getKitchen().isWithin((ILocated)barterer.getActorLocation())) continue;
            for (IItemMemorization item : barterer.readInventory()) {
                candidates.add(item);
            }
        }
        for (IItemMemorization item : candidates) {
            if (!itemPredicate.apply((Object)item)) continue;
            return item;
        }
        return null;
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.countPossessed() > this.initialPossessedMatchingItemCount) {
            this.stage = Stage.DONE;
            return;
        }
        IItemMemorization<?> item = this.findItemInMemory();
        this.stage = item != null ? (item.getActorLocation() != null ? Stage.PICK_UP : (item.getOwnerPossessor() instanceof IContainer ? Stage.TAKE : Stage.DEMAND)) : Stage.SEARCH;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case SEARCH: {
                this.clearIncorrectSubtask(this.searchTask);
                if (this.subTask == null) {
                    this.searchTask = new SearchTask(this.bot, this.bot.getKitchen().getNavPoints(), (Supplier<Boolean>)Suppliers.ofInstance((Object)false));
                    this.subTask = this.searchTask;
                }
                this.subTask.logic();
                break;
            }
            case PICK_UP: {
                this.clearIncorrectSubtask(this.pickUpTask);
                if (this.subTask == null) {
                    this.pickUpTask = new PickUpTask((EmohawkVilleChefBot<?>)this.bot, (IItem)this.findItemInMemory(), Double.POSITIVE_INFINITY);
                    this.subTask = this.pickUpTask;
                }
                this.subTask.logic();
                break;
            }
            case TAKE: {
                this.clearIncorrectSubtask(this.takeFromContainerTask);
                if (this.subTask == null) {
                    IItemMemorization<?> item = this.findItemInMemory();
                    IContainer container = (IContainer)item.getOwnerPossessor();
                    this.takeFromContainerTask = new TakeFromContainerTask(this.bot, container, (IItem)item, Double.POSITIVE_INFINITY);
                    this.subTask = this.takeFromContainerTask;
                }
                this.subTask.logic();
                break;
            }
            case DEMAND: {
                this.clearIncorrectSubtask(this.demandTask);
                if (this.subTask == null) {
                    this.demandTask = new DemandTask((EmohawkVilleChefBot<?>)this.bot, (IItem)this.findItemInMemory(), Double.POSITIVE_INFINITY);
                    this.subTask = this.demandTask;
                }
                this.subTask.logic();
                break;
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.searchTask = null;
        this.pickUpTask = null;
        this.takeFromContainerTask = null;
        this.demandTask = null;
    }

    @Override
    public String getName() {
        return "Collect";
    }

    protected IItemMemorization<?> findItemInMemory() {
        return CollectTask.findItemInMemory(this.bot, this.itemPredicate);
    }

    protected int countPossessed() {
        return Collections2.filter((Collection)this.bot.getPawn().readInventory(), this.itemPredicate).size();
    }

    protected static enum Stage {
        SEARCH,
        PICK_UP,
        TAKE,
        DEMAND,
        DONE;

    }
}

