/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.IEssenceMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.ChoppingBoardMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IChoppableItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ChoppingBoardReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IChoppingBoard;

public class ChopTask
extends AbstractTask<Stage> {
    protected double searchDuration;
    protected int boardGameObjectId;
    protected GoToTask goToTask;

    public ChopTask(EmohawkVilleChefBot<?> bot, IChoppingBoard board, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.boardGameObjectId = board.getGameObjectId();
        this.searchDuration = searchDuration;
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.bot.getActionRegistry().getChopAction().findKitchenKnife(this.bot.getPawn().readInventory()) == null) {
            this.stage = Stage.FAILED;
            return;
        }
        ChoppingBoardMemorization board = this.findBoardInMemory();
        if (board == null || this.bot.getInfo().getTime() - board.getMemorizationEpochTime() > this.searchDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        boolean finished = true;
        for (IItemMemorization item : board.readInventory()) {
            if (!(item instanceof IChoppableItem)) continue;
            finished = false;
        }
        if (finished) {
            this.stage = Stage.DONE;
            return;
        }
        this.bot.getObservationMemory().setImportance((IEssenceMemorization)board, 16.0);
        if (this.bot.getInfo().getDistance((ILocated)board.getActorLocation()) < (double)this.bot.getActionRegistry().getChopAction().getRange() * 0.9) {
            this.stage = board.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime() ? Stage.CHOP : Stage.SEARCH;
            return;
        }
        this.stage = Stage.MOVE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    this.goToTask = new GoToTask(this.bot, this.findBoardInMemory().getActorLocation(), (double)this.bot.getActionRegistry().getPickUpItemAction().getRange() * 0.9);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.findBoardInMemory().getActorLocation());
                break;
            }
            case CHOP: {
                this.clearSubTask();
                ChoppingBoardReplica boardReplica = (ChoppingBoardReplica)this.bot.getObservationMemory().getPreimage((IObjectMemorization)this.findBoardInMemory());
                this.bot.getActionRegistry().getChopAction().request(this.bot.getPawn(), boardReplica, (IActionResultHandler)new ActionErrorPrinter("Chop"));
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
    }

    @Override
    public String getName() {
        return "Chop";
    }

    protected ChoppingBoardMemorization findBoardInMemory() {
        for (ChoppingBoardMemorization board : this.bot.getObservationMemory().getAllByMemorization(ChoppingBoardMemorization.class)) {
            if (board.getGameObjectId() != this.boardGameObjectId) continue;
            return board;
        }
        return null;
    }

    protected static enum Stage {
        MOVE,
        SEARCH,
        CHOP,
        DONE,
        FAILED;

    }
}

