/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractCookTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.CookingPotMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IBoilableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IStirringSpoon;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.CookingPotReplica;

public class BoilTask
extends AbstractCookTask {
    protected static final Predicate<IItem> stirringSpoonPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof IStirringSpoon;
        }
    };

    public BoilTask(EmohawkVilleChefBot<?> bot, IStovePlate stovePlate, double searchDuration) {
        super(bot, stovePlate, searchDuration);
    }

    @Override
    protected Predicate<IItem> getToolPredicate() {
        return stirringSpoonPredicate;
    }

    @Override
    protected boolean isCooked(IIngredient ingredient) {
        return !(ingredient instanceof IBoilableIngredient) || (double)((IBoilableIngredient)ingredient).getBoiledness() == 1.0;
    }

    @Override
    protected float getCookingRange() {
        return Math.min(this.bot.getActionRegistry().getSetStovePowerAction().getRange(), this.bot.getActionRegistry().getStirAction().getRange());
    }

    @Override
    protected float getMinCookingTemperature() {
        return 80.0f;
    }

    @Override
    protected float getMaxCookingTemperature() {
        return 100.0f;
    }

    @Override
    protected void cookingLogic() {
        CookingPotReplica cookware = (CookingPotReplica)this.bot.getObservationMemory().getPreimage((IObjectMemorization)this.findCookwareInMemory());
        if (!cookware.isStirrerHidden() && cookware.getStirrer() == null) {
            this.bot.getActionRegistry().getStirAction().request(this.bot.getPawn(), cookware, (IActionResultHandler)new ActionErrorPrinter("Stir"));
        }
    }

    @Override
    protected int getTargetStovePower() {
        return 3;
    }

    @Override
    public String getName() {
        return "Boil";
    }

    protected CookingPotMemorization findCookwareInMemory() {
        return (CookingPotMemorization)super.findCookwareInMemory();
    }
}

