/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ChopTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CollectTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.PieceItemType;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.SearchTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.StoreInContainerTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.TakeFromContainerTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.ICountableItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IMergeableItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.ChoppingBoardMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IChoppableItemReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IChoppingBoard;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IKitchenKnife;
import java.util.Collection;

public class AcquirePieceItem
extends AbstractTask<Stage> {
    protected PieceItemType pieceItemType;
    protected int goalCount;
    protected CollectTask collectKnifeTask;
    protected CollectTask collectPrecursorTask;
    protected SearchTask findBoardTask;
    protected TakeFromContainerTask clearBoardTask;
    protected ChopTask chopTask;
    protected ITask putPrecursorOnBoardTask;
    protected CollectTask collectPieceItemTask;
    protected final Predicate<IItem> pieceItemPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return AcquirePieceItem.this.pieceItemType.getPieceItemClass().isInstance(item);
        }
    };
    protected final Predicate<IItem> precursorPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return AcquirePieceItem.this.pieceItemType.getPrecursorClass().isInstance(item);
        }
    };
    protected final Supplier<Boolean> hasFoundBoardSupplier = new Supplier<Boolean>(){

        public Boolean get() {
            return AcquirePieceItem.this.findBoardInMemory(BoardState.BLOCKED) != null;
        }
    };
    protected final Predicate<IChoppingBoard> boardWithPrecursorPredicate = new Predicate<IChoppingBoard>(){

        public boolean apply(IChoppingBoard choppingBoard) {
            return Collections2.filter((Collection)choppingBoard.readInventory(), AcquirePieceItem.this.precursorPredicate).size() > 0;
        }
    };
    protected final Predicate<IItem> kitchenKnifePredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof IKitchenKnife;
        }
    };

    public AcquirePieceItem(EmohawkVilleChefBot<?> bot, PieceItemType pieceItemType, int goalCount) {
        super(bot, Stage.DONE, null);
        this.pieceItemType = pieceItemType;
        this.goalCount = goalCount;
    }

    public PieceItemType getPieceItemType() {
        return this.pieceItemType;
    }

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        if (this.countPossessedPieceItems(CountMethod.FIRST_STACK) >= this.goalCount) {
            this.stage = Stage.DONE;
            return;
        }
        if (this.countPossessedPieceItems(CountMethod.ALL) >= this.goalCount) {
            this.stage = Stage.MERGE;
            return;
        }
        if (CollectTask.findItemInMemory(this.bot, this.pieceItemPredicate) != null) {
            this.stage = Stage.COLLECT_PIECE_ITEM;
            return;
        }
        if (this.bot.getActionRegistry().getChopAction().findKitchenKnife(this.bot.getPawn().readInventory()) == null && CollectTask.findItemInMemory(this.bot, this.kitchenKnifePredicate) != null) {
            this.stage = Stage.COLLECT_KNIFE;
            return;
        }
        ChoppingBoardMemorization board = this.findBoardInMemory(BoardState.READY);
        if (board != null) {
            this.stage = Stage.CHOP_PRECURSOR;
            return;
        }
        if (this.findPrecursorInInventory() == null) {
            this.stage = Stage.COLLECT_PRECURSOR;
            return;
        }
        board = this.findBoardInMemory(BoardState.EMPTY);
        if (board != null) {
            this.stage = Stage.PUT_PRECURSOR_ON_BOARD;
            return;
        }
        board = this.findBoardInMemory(BoardState.BLOCKED);
        if (board != null) {
            this.stage = Stage.CLEAR_BOARD;
            return;
        }
        this.stage = Stage.FIND_BOARD;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case COLLECT_KNIFE: {
                this.clearIncorrectSubtask(this.collectKnifeTask);
                if (this.subTask == null) {
                    this.collectKnifeTask = new CollectTask(this.bot, this.kitchenKnifePredicate);
                    this.subTask = this.collectKnifeTask;
                }
                this.subTask.logic();
                break;
            }
            case COLLECT_PRECURSOR: {
                this.clearIncorrectSubtask(this.collectPrecursorTask);
                if (this.subTask == null) {
                    this.collectPrecursorTask = new CollectTask(this.bot, this.precursorPredicate);
                    this.subTask = this.collectPrecursorTask;
                }
                this.subTask.logic();
                break;
            }
            case FIND_BOARD: {
                this.clearIncorrectSubtask(this.findBoardTask);
                if (this.subTask == null) {
                    this.findBoardTask = new SearchTask(this.bot, this.bot.getKitchen().getNavPoints(), this.hasFoundBoardSupplier);
                    this.subTask = this.findBoardTask;
                }
                this.subTask.logic();
                break;
            }
            case CLEAR_BOARD: {
                this.clearIncorrectSubtask(this.clearBoardTask);
                if (this.subTask == null) {
                    ChoppingBoardMemorization board = this.findBoardInMemory(BoardState.BLOCKED);
                    this.clearBoardTask = new TakeFromContainerTask(this.bot, (IContainer)board, (IItem)board.readInventory().iterator().next(), Double.POSITIVE_INFINITY);
                    this.subTask = this.clearBoardTask;
                }
                this.subTask.logic();
                break;
            }
            case PUT_PRECURSOR_ON_BOARD: {
                this.clearIncorrectSubtask(this.putPrecursorOnBoardTask);
                if (this.subTask == null) {
                    this.subTask = this.putPrecursorOnBoardTask = new StoreInContainerTask(this.bot, (IContainer)this.findBoardInMemory(BoardState.EMPTY), (IItem)this.findPrecursorInInventory(), Double.POSITIVE_INFINITY);
                }
                this.subTask.logic();
                break;
            }
            case CHOP_PRECURSOR: {
                this.clearIncorrectSubtask(this.chopTask);
                if (this.subTask == null) {
                    this.chopTask = new ChopTask(this.bot, (IChoppingBoard)this.findBoardInMemory(BoardState.READY), Double.POSITIVE_INFINITY);
                    this.subTask = this.chopTask;
                }
                this.subTask.logic();
                break;
            }
            case COLLECT_PIECE_ITEM: {
                this.clearIncorrectSubtask(this.collectPieceItemTask);
                if (this.subTask == null) {
                    this.collectPieceItemTask = new CollectTask(this.bot, this.pieceItemPredicate);
                    this.subTask = this.collectPieceItemTask;
                }
                this.subTask.logic();
                break;
            }
            case MERGE: {
                this.clearSubTask();
                IMergeableItemReplica[] merged = new IMergeableItemReplica[]{null, null};
                int i = 0;
                for (IItemReplica item : this.bot.getPawn().readInventory()) {
                    if (!this.pieceItemPredicate.apply((Object)item)) continue;
                    merged[i] = (IMergeableItemReplica)item;
                    if (++i < 2) continue;
                    break;
                }
                this.bot.getActionRegistry().getMergeItemAction().request((ICollectorReplica)this.bot.getPawn(), merged[0], merged[1], (IActionResultHandler)new ActionErrorPrinter("Merge piece item"));
                break;
            }
            case DONE: {
                this.clearSubTask();
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.collectKnifeTask = null;
        this.collectPrecursorTask = null;
        this.findBoardTask = null;
        this.clearBoardTask = null;
        this.chopTask = null;
        this.putPrecursorOnBoardTask = null;
        this.collectPieceItemTask = null;
    }

    @Override
    public String getName() {
        return "AcquirePieceItem[" + this.pieceItemType.toString() + "]";
    }

    protected int countPossessedPieceItems(CountMethod countMethod) {
        int count = 0;
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (!this.pieceItemPredicate.apply((Object)item)) continue;
            count += ((ICountableItem)item).getCount();
            if (countMethod != CountMethod.FIRST_STACK) continue;
            return count;
        }
        return count;
    }

    protected IChoppableItemReplica findPrecursorInInventory() {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (!this.precursorPredicate.apply((Object)item)) continue;
            return (IChoppableItemReplica)item;
        }
        return null;
    }

    protected ChoppingBoardMemorization findBoardInMemory(BoardState requiredState) {
        ChoppingBoardMemorization freshestMatchingBoardMemorization = null;
        double freshestEpochTime = Double.NEGATIVE_INFINITY;
        for (ChoppingBoardMemorization board : this.bot.getObservationMemory().getAllByMemorization(ChoppingBoardMemorization.class)) {
            if (!(freshestEpochTime < board.getMemorizationEpochTime()) || !this.bot.getKitchen().isWithin((ILocated)board.getActorLocation()) || requiredState == BoardState.READY && !this.boardWithPrecursorPredicate.apply((Object)board) || requiredState == BoardState.EMPTY && !board.readInventory().isEmpty()) continue;
            freshestMatchingBoardMemorization = board;
            freshestEpochTime = board.getMemorizationEpochTime();
        }
        return freshestMatchingBoardMemorization;
    }

    protected static enum CountMethod {
        FIRST_STACK,
        ALL;

    }

    protected static enum BoardState {
        EMPTY,
        BLOCKED,
        READY;

    }

    protected static enum Stage {
        COLLECT_KNIFE,
        COLLECT_PRECURSOR,
        FIND_BOARD,
        CLEAR_BOARD,
        PUT_PRECURSOR_ON_BOARD,
        CHOP_PRECURSOR,
        COLLECT_PIECE_ITEM,
        MERGE,
        DONE;

    }
}

