/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractAcquireCookedIngredientTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.FryTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IFriableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IOil;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.IFryingPan;

public class AcquireFriedIngredientTask
extends AbstractAcquireCookedIngredientTask {
    protected static final Predicate<IItem> oilPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof IOil;
        }
    };

    public AcquireFriedIngredientTask(EmohawkVilleChefBot<?> bot, Class<? extends IFriableIngredient> ingredientClass, double goalVolume) {
        super(bot, ingredientClass, goalVolume);
    }

    @Override
    protected boolean isCompatibleCookware(ICookware cookware) {
        return cookware instanceof IFryingPan;
    }

    @Override
    protected Predicate<IItem> getCookingLiquidPredicate() {
        return oilPredicate;
    }

    @Override
    protected float getMinCookingLiquidVolume() {
        return 0.01f;
    }

    @Override
    protected float getMaxCookingLiquidVolume() {
        return 0.02f;
    }

    @Override
    protected boolean isCooked(IIngredient ingredient) {
        if (ingredient instanceof IFriableIngredient) {
            IFriableIngredient friableIngredient = (IFriableIngredient)ingredient;
            return (double)friableIngredient.getBottomFriedness() == 1.0 && (double)friableIngredient.getTopFriedness() == 1.0;
        }
        return true;
    }

    @Override
    protected ITask makeCookTask() {
        return new FryTask(this.bot, (IStovePlate)this.findCookwareInMemory(AbstractAcquireCookedIngredientTask.CookwareState.PLACED_READY).getOwnerPossessor(), Double.POSITIVE_INFINITY);
    }

    @Override
    public String getName() {
        return "Acquire fried " + this.ingredientClass.getSimpleName();
    }
}

