/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractAcquireCookedIngredientTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.BoilTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IWater;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IBoilableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IBroth;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookingPot;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;

public class AcquireBoiledIngredientTask
extends AbstractAcquireCookedIngredientTask {
    protected static final Predicate<IItem> waterPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return item instanceof IWater || item instanceof IBroth;
        }
    };

    public AcquireBoiledIngredientTask(EmohawkVilleChefBot<?> bot, Class<? extends IBoilableIngredient> ingredientClass, double goalVolume) {
        super(bot, ingredientClass, goalVolume);
    }

    @Override
    protected boolean isCompatibleCookware(ICookware cookware) {
        return cookware instanceof ICookingPot;
    }

    @Override
    protected Predicate<IItem> getCookingLiquidPredicate() {
        return waterPredicate;
    }

    @Override
    protected float getMinCookingLiquidVolume() {
        return 1.0f;
    }

    @Override
    protected float getMaxCookingLiquidVolume() {
        return 2.0f;
    }

    @Override
    protected boolean isCooked(IIngredient ingredient) {
        return !(ingredient instanceof IBoilableIngredient) || (double)((IBoilableIngredient)ingredient).getBoiledness() == 1.0;
    }

    @Override
    protected ITask makeCookTask() {
        return new BoilTask(this.bot, (IStovePlate)this.findCookwareInMemory(AbstractAcquireCookedIngredientTask.CookwareState.PLACED_READY).getOwnerPossessor(), Double.POSITIVE_INFINITY);
    }

    @Override
    public String getName() {
        return "Acquire boiled " + this.ingredientClass.getSimpleName();
    }
}

