/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;

public abstract class AbstractTask<Stage>
implements ITask {
    protected EmohawkVilleChefBot<?> bot;
    protected ITask subTask;
    protected Stage stage;
    protected Stage successStage;
    protected Stage failureStage;

    public AbstractTask(EmohawkVilleChefBot<?> bot, Stage successStage, Stage failureStage) {
        this.bot = bot;
        this.stage = null;
        this.successStage = successStage;
        this.failureStage = failureStage;
    }

    @Override
    public void logic() {
        this.updateStage();
        this.stageLogic();
    }

    @Override
    public boolean hasFinished() {
        this.updateStage();
        return this.isFinalStage(this.stage);
    }

    @Override
    public boolean hasFailed() {
        this.updateStage();
        return this.stage == this.failureStage;
    }

    @Override
    public boolean hasSucceded() {
        this.updateStage();
        return this.stage == this.successStage;
    }

    @Override
    public void abort() {
        this.clearSubTask();
    }

    @Override
    public ITask getSubTask() {
        this.updateStage();
        return this.subTask;
    }

    public String toString() {
        this.updateStage();
        return this.getName() + "/" + this.stage.toString();
    }

    public abstract String getName();

    protected boolean isFinalStage(Stage stage) {
        return stage != null && (stage == this.successStage || stage == this.failureStage);
    }

    protected void updateStage() {
    }

    protected void stageLogic() {
    }

    protected void clearSubTask() {
        if (this.subTask != null) {
            this.subTask.abort();
            this.subTask = null;
        }
    }

    protected void clearIncorrectSubtask(ITask correctTask) {
        this.clearIncorrectSubtask(correctTask, false);
    }

    protected void clearIncorrectSubtask(ITask expectedTask, boolean force) {
        if (this.subTask != expectedTask || this.subTask == null || this.subTask.hasFinished() || force) {
            this.clearSubTask();
        }
    }
}

