/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.object.IObjectMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CollectTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.GoToTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.StovePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.ingredient.IIngredientMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.ICookwareMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StovePlateReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.StoveReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;

public abstract class AbstractCookTask
extends AbstractTask<Stage> {
    protected double searchDuration;
    protected int stovePlateGameObjectId;
    protected GoToTask goToTask;
    protected CollectTask collectToolTask;

    public AbstractCookTask(EmohawkVilleChefBot<?> bot, IStovePlate stovePlate, double searchDuration) {
        super(bot, Stage.DONE, Stage.FAILED);
        this.stovePlateGameObjectId = stovePlate.getGameObjectId();
        this.searchDuration = searchDuration;
    }

    protected abstract Predicate<IItem> getToolPredicate();

    protected abstract boolean isCooked(IIngredient var1);

    protected abstract float getCookingRange();

    protected abstract float getMinCookingTemperature();

    protected abstract float getMaxCookingTemperature();

    protected abstract void cookingLogic();

    protected abstract int getTargetStovePower();

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        StovePlateMemorization stovePlate = this.findStovePlateInMemory();
        ICookwareMemorization<?> cookware = this.findCookwareInMemory();
        if (stovePlate == null || cookware == null || this.bot.getInfo().getTime() - stovePlate.getMemorizationEpochTime() > this.searchDuration) {
            this.stage = Stage.FAILED;
            return;
        }
        boolean allCooked = true;
        for (IIngredientMemorization ingredient : cookware.readIngredients()) {
            if (this.isCooked((IIngredient)ingredient)) continue;
            allCooked = false;
        }
        if (allCooked) {
            this.stage = Stage.DONE;
            return;
        }
        boolean hasTool = false;
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (!this.getToolPredicate().apply((Object)item)) continue;
            hasTool = true;
            break;
        }
        if (!hasTool) {
            this.stage = Stage.COLLECT_TOOL;
            return;
        }
        if (this.bot.getInfo().getDistance((ILocated)stovePlate.getActorLocation()) < (double)this.getCookingRange() * 0.5) {
            if (stovePlate.getMemorizationEpochTime() == this.bot.getObservationMemory().getEpochTime()) {
                if (cookware.getTemperature() < this.getMinCookingTemperature() || this.getMaxCookingTemperature() < cookware.getTemperature()) {
                    this.stage = stovePlate.getStove() != null ? Stage.SET_POWER : Stage.SEARCH;
                    return;
                }
                this.stage = Stage.COOK;
            } else {
                this.stage = Stage.SEARCH;
            }
            return;
        }
        this.stage = Stage.MOVE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case COLLECT_TOOL: {
                this.clearIncorrectSubtask(this.collectToolTask);
                if (this.subTask == null) {
                    this.collectToolTask = new CollectTask(this.bot, this.getToolPredicate());
                    this.subTask = this.collectToolTask;
                }
                this.subTask.logic();
                break;
            }
            case MOVE: {
                this.clearIncorrectSubtask(this.goToTask);
                if (this.subTask == null) {
                    this.goToTask = new GoToTask(this.bot, this.findStovePlateInMemory().getActorLocation(), (double)this.getCookingRange() * 0.5);
                    this.subTask = this.goToTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH: {
                this.clearSubTask();
                this.bot.getMove().turnTo((ILocated)this.findStovePlateInMemory().getActorLocation());
                break;
            }
            case SET_POWER: {
                this.clearSubTask();
                StovePlateReplica stovePlate = (StovePlateReplica)this.bot.getObservationMemory().getPreimage((IObjectMemorization)this.findStovePlateInMemory());
                StoveReplica stove = stovePlate.getStove();
                for (int i = 0; i < 4; ++i) {
                    if (stove.getPlate(i) != stovePlate || stove.getPower(i) == this.getTargetStovePower()) continue;
                    this.bot.getActionRegistry().getSetStovePowerAction().request(this.bot.getPawn(), stove, i, this.getTargetStovePower(), (IActionResultHandler)new ActionErrorPrinter("Set stove power"));
                }
                break;
            }
            case COOK: {
                this.clearSubTask();
                this.cookingLogic();
                break;
            }
            case DONE: 
            case FAILED: {
                this.clearSubTask();
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.goToTask = null;
        this.collectToolTask = null;
    }

    protected ICookwareMemorization<?> findCookwareInMemory() {
        StovePlateMemorization stovePlate = this.findStovePlateInMemory();
        if (stovePlate == null || stovePlate.readInventory().isEmpty()) {
            return null;
        }
        return (ICookwareMemorization)stovePlate.readInventory().iterator().next();
    }

    protected StovePlateMemorization findStovePlateInMemory() {
        for (StovePlateMemorization stovePlate : this.bot.getObservationMemory().getAllByMemorization(StovePlateMemorization.class)) {
            if (stovePlate.getGameObjectId() != this.stovePlateGameObjectId) continue;
            return stovePlate;
        }
        return null;
    }

    protected static enum Stage {
        COLLECT_TOOL,
        MOVE,
        SEARCH,
        SET_POWER,
        COOK,
        DONE,
        FAILED;

    }
}

