/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.memorization.essence.IEssenceMemorization;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplica;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AbstractTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.AcquirePieceItem;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.CollectTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.ITask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.PieceItemType;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.SearchTask;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.task.StoreInContainerTask;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.ISubstanceItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.StovePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.ICookwareMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookware;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.ICookwareReplica;
import java.util.ArrayList;

public abstract class AbstractAcquireCookedIngredientTask
extends AbstractTask<Stage> {
    public static final double MAX_GOAL_VOLUME = 1.0;
    protected Class<? extends IIngredient> ingredientClass;
    protected double goalVolume;
    protected CollectTask collectCookwareTask = null;
    protected SearchTask searchTask = null;
    protected StoreInContainerTask placeCookwareTask = null;
    protected CollectTask collectCookingLiquidTask = null;
    protected StoreInContainerTask addCookingLiquidTask = null;
    protected ITask acquireIngredientTask = null;
    protected StoreInContainerTask addIngredientTask = null;
    protected CollectTask collectToolTask = null;
    protected CollectTask collectFinishedTask = null;
    protected ITask cookTask = null;
    protected final Predicate<IItem> ingredientPredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            return AbstractAcquireCookedIngredientTask.this.ingredientClass.isInstance(item);
        }
    };
    protected final Predicate<IItem> freeCookwarePredicate = new Predicate<IItem>(){

        public boolean apply(IItem item) {
            if (item instanceof ICookware) {
                ICookware cookware = (ICookware)item;
                return AbstractAcquireCookedIngredientTask.this.isCompatibleCookware(cookware) && AbstractAcquireCookedIngredientTask.this.checkCookwareInternalState(cookware, CookwareState.FREE);
            }
            return false;
        }
    };

    public AbstractAcquireCookedIngredientTask(EmohawkVilleChefBot<?> bot, Class<? extends IIngredient> ingredientClass, double goalVolume) {
        super(bot, Stage.DONE, null);
        this.ingredientClass = ingredientClass;
        this.goalVolume = goalVolume;
        assert (goalVolume <= 1.0);
    }

    public Class<? extends IIngredient> getIngredientClass() {
        return this.ingredientClass;
    }

    protected abstract boolean isCompatibleCookware(ICookware var1);

    protected abstract Predicate<IItem> getCookingLiquidPredicate();

    protected abstract float getMinCookingLiquidVolume();

    protected abstract float getMaxCookingLiquidVolume();

    protected abstract boolean isCooked(IIngredient var1);

    protected abstract ITask makeCookTask();

    @Override
    protected void updateStage() {
        if (this.isFinalStage(this.stage)) {
            return;
        }
        ICookwareMemorization<?> cookware = this.findCookwareInMemory(CookwareState.POSSESED_FINISHED);
        if (cookware != null) {
            this.stage = Stage.DONE;
            return;
        }
        cookware = this.findCookwareInMemory(CookwareState.FINISHED);
        if (cookware != null) {
            if (cookware.getOwnerPossessor() == null) {
                this.bot.getObservationMemory().setImportance(cookware, 16.0);
            }
            this.stage = Stage.COLLECT_FINISHED;
            return;
        }
        cookware = this.findCookwareInMemory(CookwareState.PLACED_READY);
        if (cookware != null) {
            this.stage = Stage.COOK;
            return;
        }
        cookware = this.findCookwareInMemory(CookwareState.PLACED_WITH_LIQUID);
        if (cookware != null) {
            this.stage = this.findIngredientInInventory() != null ? Stage.ADD_INGREDIENT : Stage.ACQUIRE_INGREDIENT;
            return;
        }
        cookware = this.findCookwareInMemory(CookwareState.PLACED);
        if (cookware != null) {
            CookwareInfo cookwareInfo = this.inspectCookware((ICookware)cookware);
            ISubstanceItemReplica cookingLiquid = this.findCookingLiquidInInventory(this.getMaxCookingLiquidVolume() - cookwareInfo.cookingLiquidVolume);
            if (cookingLiquid != null) {
                this.stage = Stage.ADD_COOKING_LIQUID;
                return;
            }
            cookingLiquid = this.findCookingLiquidInInventory(Float.POSITIVE_INFINITY);
            this.stage = cookingLiquid != null ? Stage.SPLIT_COOKING_LIQUID : Stage.COLLECT_COOKING_LIQUID;
            return;
        }
        cookware = this.findCookwareInMemory(CookwareState.POSSESED);
        if (cookware != null) {
            StovePlateMemorization stovePlate = this.findFreeStovePlateInMemory();
            if (stovePlate != null) {
                this.bot.getObservationMemory().setImportance((IEssenceMemorization)stovePlate, 16.0);
                this.stage = Stage.PLACE_COOKWARE;
            } else {
                this.stage = Stage.SEARCH_STOVE;
            }
            return;
        }
        this.stage = Stage.COLLECT_COOKWARE;
    }

    @Override
    protected void stageLogic() {
        switch ((Stage)((Object)this.stage)) {
            case COLLECT_COOKWARE: {
                this.clearIncorrectSubtask(this.collectCookwareTask);
                if (this.subTask == null) {
                    this.collectCookwareTask = new CollectTask(this.bot, this.freeCookwarePredicate);
                    this.subTask = this.collectCookwareTask;
                }
                this.subTask.logic();
                break;
            }
            case SEARCH_STOVE: {
                this.clearIncorrectSubtask(this.searchTask);
                if (this.subTask == null) {
                    this.searchTask = new SearchTask(this.bot, this.bot.getKitchen().getNavPoints(), (Supplier<Boolean>)Suppliers.ofInstance((Object)false));
                    this.subTask = this.searchTask;
                }
                this.subTask.logic();
                break;
            }
            case PLACE_COOKWARE: {
                this.clearIncorrectSubtask(this.placeCookwareTask);
                if (this.subTask == null) {
                    StovePlateMemorization stovePlate = this.findFreeStovePlateInMemory();
                    this.placeCookwareTask = new StoreInContainerTask(this.bot, (IContainer)stovePlate, (IItem)this.findCookwareInMemory(CookwareState.POSSESED), Double.POSITIVE_INFINITY);
                    this.subTask = this.placeCookwareTask;
                }
                this.subTask.logic();
                break;
            }
            case COLLECT_COOKING_LIQUID: {
                this.clearIncorrectSubtask(this.collectCookingLiquidTask);
                if (this.subTask == null) {
                    this.collectCookingLiquidTask = new CollectTask(this.bot, this.getCookingLiquidPredicate());
                    this.subTask = this.collectCookingLiquidTask;
                }
                this.subTask.logic();
                break;
            }
            case SPLIT_COOKING_LIQUID: {
                this.clearSubTask();
                ISubstanceItemReplica cookingLiquid = this.findCookingLiquidInInventory(Float.POSITIVE_INFINITY);
                ICookwareMemorization<?> cookware = this.findCookwareInMemory(CookwareState.PLACED);
                CookwareInfo cookwareInfo = this.inspectCookware((ICookware)cookware);
                float splitVolume = (this.getMinCookingLiquidVolume() + this.getMaxCookingLiquidVolume()) / 2.0f - cookwareInfo.cookingLiquidVolume;
                this.bot.getActionRegistry().getSplitItemAction().requestSplitSubstance((ICollectorReplica)this.bot.getPawn(), cookingLiquid, splitVolume, (IActionResultHandler)new ActionErrorPrinter("Split cooking liquid"));
                break;
            }
            case ADD_COOKING_LIQUID: {
                this.clearIncorrectSubtask(this.addCookingLiquidTask);
                if (this.subTask == null) {
                    ICookwareMemorization<?> cookware = this.findCookwareInMemory(CookwareState.PLACED);
                    ISubstanceItemReplica cookingLiquid = this.findCookingLiquidInInventory(this.getMaxCookingLiquidVolume() - this.inspectCookware(this.findCookwareInMemory((CookwareState)CookwareState.PLACED)).cookingLiquidVolume);
                    this.addCookingLiquidTask = new StoreInContainerTask(this.bot, (IContainer)cookware, (IItem)cookingLiquid, Double.POSITIVE_INFINITY);
                    this.subTask = this.addCookingLiquidTask;
                }
                this.subTask.logic();
                break;
            }
            case ACQUIRE_INGREDIENT: {
                this.clearIncorrectSubtask(this.acquireIngredientTask);
                if (this.subTask == null) {
                    PieceItemType pieceItemType = PieceItemType.classToType(this.ingredientClass);
                    this.acquireIngredientTask = pieceItemType != null ? new AcquirePieceItem(this.bot, pieceItemType, 1) : new CollectTask(this.bot, this.ingredientPredicate);
                    this.subTask = this.acquireIngredientTask;
                }
                this.subTask.logic();
                break;
            }
            case ADD_INGREDIENT: {
                this.clearIncorrectSubtask(this.addIngredientTask);
                if (this.subTask == null) {
                    ICookwareMemorization<?> cookware = this.findCookwareInMemory(CookwareState.PLACED_WITH_LIQUID);
                    this.addIngredientTask = new StoreInContainerTask(this.bot, (IContainer)cookware, (IItem)this.findIngredientInInventory(), Double.POSITIVE_INFINITY);
                    this.subTask = this.addIngredientTask;
                }
                this.subTask.logic();
                break;
            }
            case COOK: {
                this.clearIncorrectSubtask(this.cookTask);
                if (this.subTask == null) {
                    this.subTask = this.cookTask = this.makeCookTask();
                }
                this.subTask.logic();
                break;
            }
            case COLLECT_FINISHED: {
                this.clearIncorrectSubtask(this.collectFinishedTask);
                if (this.subTask == null) {
                    this.collectFinishedTask = new CollectTask(this.bot, new Predicate<IItem>(){

                        public boolean apply(IItem item) {
                            if (item instanceof ICookware) {
                                ICookware cookware = (ICookware)item;
                                return AbstractAcquireCookedIngredientTask.this.isCompatibleCookware(cookware) && AbstractAcquireCookedIngredientTask.this.checkCookwareInternalState(cookware, CookwareState.FINISHED);
                            }
                            return false;
                        }
                    });
                    this.subTask = this.collectFinishedTask;
                }
                this.subTask.logic();
                break;
            }
            case DONE: {
                this.clearSubTask();
            }
        }
    }

    @Override
    protected void clearSubTask() {
        super.clearSubTask();
        this.collectCookwareTask = null;
        this.searchTask = null;
        this.placeCookwareTask = null;
        this.collectCookingLiquidTask = null;
        this.addCookingLiquidTask = null;
        this.acquireIngredientTask = null;
        this.addIngredientTask = null;
        this.collectToolTask = null;
        this.collectFinishedTask = null;
        this.cookTask = null;
    }

    protected StovePlateMemorization findFreeStovePlateInMemory() {
        for (StovePlateMemorization stovePlate : this.bot.getObservationMemory().getAllByMemorization(StovePlateMemorization.class)) {
            if (!stovePlate.readInventory().isEmpty() || !this.bot.getKitchen().isWithin((ILocated)stovePlate.getActorLocation())) continue;
            return stovePlate;
        }
        return null;
    }

    protected IIngredient findIngredientInInventory() {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            if (!this.ingredientClass.isInstance(item)) continue;
            return (IIngredient)item;
        }
        return null;
    }

    protected ISubstanceItemReplica findCookingLiquidInInventory(float maxVolume) {
        for (IItemReplica item : this.bot.getPawn().readInventory()) {
            ISubstanceItemReplica cookingLiquid;
            if (!this.getCookingLiquidPredicate().apply((Object)item) || !((cookingLiquid = (ISubstanceItemReplica)item).getAmount() < maxVolume)) continue;
            return cookingLiquid;
        }
        return null;
    }

    protected ICookwareMemorization<?> findCookwareInMemory(CookwareState requiredState) {
        ArrayList<ICookwareMemorization> candidates = new ArrayList<ICookwareMemorization>();
        switch (requiredState) {
            case FREE: {
                for (ICookwareMemorization cookware : this.bot.getObservationMemory().getAllByMemorization(ICookwareMemorization.class)) {
                    if (!this.bot.getKitchen().isWithin((ILocated)cookware.getActorLocation())) continue;
                    candidates.add(cookware);
                }
                break;
            }
            case POSSESED: 
            case POSSESED_FINISHED: {
                for (IItemReplica item : this.bot.getPawn().readInventory()) {
                    if (!(item instanceof ICookwareReplica)) continue;
                    candidates.add((ICookwareMemorization)this.bot.getObservationMemory().getMemorization((IObjectReplica)item));
                }
                break;
            }
            case PLACED: 
            case PLACED_WITH_LIQUID: 
            case PLACED_READY: 
            case FINISHED: {
                for (StovePlateMemorization stovePlate : this.bot.getObservationMemory().getAllByMemorization(StovePlateMemorization.class)) {
                    if (!this.bot.getKitchen().isWithin((ILocated)stovePlate.getActorLocation())) continue;
                    for (IItemMemorization item : stovePlate.readInventory()) {
                        if (!(item instanceof ICookwareMemorization)) continue;
                        candidates.add((ICookwareMemorization)item);
                    }
                }
                break;
            }
        }
        for (ICookwareMemorization cookware : candidates) {
            if (!this.isCompatibleCookware((ICookware)cookware) || !this.checkCookwareInternalState((ICookware)cookware, requiredState)) continue;
            return cookware;
        }
        return null;
    }

    protected boolean checkCookwareInternalState(ICookware cookware, CookwareState requiredState) {
        CookwareInfo cookwareInfo = this.inspectCookware(cookware);
        if (cookwareInfo.hasContaminants || this.getMaxCookingLiquidVolume() < cookwareInfo.cookingLiquidVolume) {
            return false;
        }
        switch (requiredState) {
            case POSSESED_FINISHED: 
            case FINISHED: {
                return (double)cookwareInfo.cookedIngredientVolume >= this.goalVolume;
            }
            case PLACED_READY: {
                return this.getMinCookingLiquidVolume() <= cookwareInfo.cookingLiquidVolume && this.goalVolume < (double)cookwareInfo.ingredientVolume;
            }
            case PLACED_WITH_LIQUID: {
                return this.getMinCookingLiquidVolume() <= cookwareInfo.cookingLiquidVolume;
            }
            case FREE: 
            case POSSESED: 
            case PLACED: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unexpected state " + (Object)((Object)requiredState) + "."));
    }

    protected CookwareInfo inspectCookware(ICookware cookware) {
        CookwareInfo retval = new CookwareInfo();
        for (IIngredient ingredient : cookware.readIngredients()) {
            if (this.getCookingLiquidPredicate().apply((Object)ingredient)) {
                retval.cookingLiquidVolume += ingredient.getVolume();
                continue;
            }
            if (this.ingredientClass.isInstance(ingredient)) {
                retval.ingredientVolume += ingredient.getVolume();
                if (!this.isCooked(ingredient)) continue;
                retval.cookedIngredientVolume += ingredient.getVolume();
                continue;
            }
            retval.hasContaminants = true;
        }
        return retval;
    }

    protected static enum CookwareState {
        FREE,
        POSSESED,
        PLACED,
        PLACED_WITH_LIQUID,
        PLACED_READY,
        FINISHED,
        POSSESED_FINISHED;

    }

    protected static enum Stage {
        COLLECT_COOKWARE,
        SEARCH_STOVE,
        PLACE_COOKWARE,
        COLLECT_COOKING_LIQUID,
        SPLIT_COOKING_LIQUID,
        ADD_COOKING_LIQUID,
        ACQUIRE_INGREDIENT,
        ADD_INGREDIENT,
        COOK,
        COLLECT_FINISHED,
        DONE;

    }

    protected class CookwareInfo {
        public float cookingLiquidVolume = 0.0f;
        public float ingredientVolume = 0.0f;
        public float cookedIngredientVolume = 0.0f;
        public boolean hasContaminants = false;

        protected CookwareInfo() {
        }
    }
}

