/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.examples.chefbot;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.util.ArrayList;
import java.util.List;

public class Kitchen {
    protected IWorldView worldView;
    protected String mapName;
    protected Location center;
    protected double radius;
    protected List<NavPoint> navPoints;

    public Kitchen(IWorldView worldView, String mapName, int kitchenIndex) {
        this.worldView = worldView;
        this.mapName = mapName;
        this.navPoints = new ArrayList<NavPoint>();
        if ("EV-EmohawkVille_v06b".equalsIgnoreCase(mapName)) {
            this.initEmohawkUdk06b();
        } else if ("EV-HellsKitchen_v02".equalsIgnoreCase(mapName)) {
            this.initHellsKitchen(kitchenIndex);
        } else {
            throw new RuntimeException("Unknown map " + mapName + ".");
        }
    }

    public List<NavPoint> getNavPoints() {
        return this.navPoints;
    }

    public Location getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isWithin(ILocated located) {
        return this.center.getDistance2D(located.getLocation()) < this.radius;
    }

    protected void initEmohawkUdk06b() {
        this.center = new Location(750.0, -1875.0, 65.0);
        this.radius = 1024.0;
        this.navPoints.add(this.getNav("PathNode_10"));
        this.navPoints.add(this.getNav("PathNode_17"));
        this.navPoints.add(this.getNav("PathNode_64"));
        this.navPoints.add(this.getNav("PathNode_294"));
        this.navPoints.add(this.getNav("PathNode_544"));
        this.navPoints.add(this.getNav("PathNode_545"));
        this.navPoints.add(this.getNav("PathNode_552"));
        this.navPoints.add(this.getNav("PathNode_546"));
        this.navPoints.add(this.getNav("PathNode_547"));
        this.navPoints.add(this.getNav("PathNode_548"));
        this.navPoints.add(this.getNav("PathNode_549"));
        this.navPoints.add(this.getNav("PathNode_550"));
        this.navPoints.add(this.getNav("PathNode_551"));
    }

    protected void initHellsKitchen(int kitchenIndex) {
        this.radius = 640.0;
        if (0 <= kitchenIndex && kitchenIndex < 4) {
            this.center = new Location((double)(1536 - kitchenIndex * 1024), 1536.0, 50.0);
        } else if (kitchenIndex < 8) {
            this.center = new Location((double)(1536 - (kitchenIndex - 4) * 1024), -1536.0, 50.0);
        } else {
            throw new RuntimeException("Invalid kitchen index.");
        }
        for (NavPoint navPoint : this.worldView.getAll(NavPoint.class).values()) {
            if (!this.isWithin((ILocated)navPoint)) continue;
            this.navPoints.add(navPoint);
        }
    }

    protected NavPoint getNav(String name) {
        NavPoint retval = (NavPoint)this.worldView.getAll(NavPoint.class).get(WorldObjectId.get((String)name));
        assert (retval != null);
        return retval;
    }
}

