package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import java.util.ArrayList;
import java.util.Collection;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container.IContainerMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.StovePlateMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.ICookwareMemorization;

/** Store an item in a non-ethereal container at known location
 * 
 * @author Paletz
 */
public class StoreInContainerTask extends AbstractTask<StoreInContainerTask.Stage> {

	protected double searchDuration;
	protected int containerGameObjectId;
	protected int itemGameObjectId;
	
	protected GoToTask goToTask;
	
	/** Create a store item task  
	 * 
	 * @param bot bot picking up the item
	 * @param container container to store to
	 * @param item item to store
	 * @param searchDuration how old item memorization is acceptable
	 */
	public StoreInContainerTask( EmohawkVilleChefBot<?> bot, IContainer container, IItem item, double searchDuration ) {
		super( bot, Stage.DONE, Stage.FAILED );
		this.searchDuration = searchDuration;
		this.containerGameObjectId = container.getGameObjectId();
		this.itemGameObjectId = item.getGameObjectId();
	}
		
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( findItemInInventory() == null ) {
			stage = Stage.DONE;
			return;
		}
		
		IContainerMemorization<?> container = findContainerInMemory();
		if ( container == null || bot.getInfo().getTime() - container.getMemorizationEpochTime() > searchDuration ) {
			stage = Stage.FAILED;
			return;
		}
		
		if ( container.getActorLocation() != null ) {
			bot.getObservationMemory().setImportance( container, 16.0 );
		} else {
			bot.getObservationMemory().setImportance( ((ICookwareMemorization<?>) container).getOwnerPossessor(), 16.0 );
		}
		
		Location containerLocation = container.getActorLocation();
		if ( containerLocation == null ) {
			containerLocation = ((IItem) container).getOwnerPossessor().getActorLocation();
		}
		if ( bot.getInfo().getDistance( containerLocation ) < bot.getActionRegistry().getStoreItemInContainerAction().getRange()*0.9 ) {
			if ( container.getMemorizationEpochTime() == bot.getObservationMemory().getEpochTime() ) {
				stage = Stage.STORE;
			} else {
				stage = Stage.SEARCH;
			}
		} else {
			stage = Stage.MOVE;
		}
		return;
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case MOVE:
			clearIncorrectSubtask( goToTask );

			if ( subTask == null ) {
				IContainer container = findContainerInMemory();
				Location containerLocation = container.getActorLocation();
				if ( containerLocation == null ) {
					containerLocation = ((IItem) container).getOwnerPossessor().getActorLocation();
				}
				subTask = goToTask = new GoToTask( 
					bot,
					containerLocation, 
					bot.getActionRegistry().getStoreItemInContainerAction().getRange()*0.9 
				);
			}
			
			subTask.logic();
			break;
		case SEARCH:
			clearSubTask();
			bot.getMove().turnTo( getEffectiveContainerLocation( findContainerInMemory() ) );
			break;
		case STORE:
			clearSubTask();
			IContainerMemorization<?> container = findContainerInMemory();
			IContainerReplica containerReplica = bot.getObservationMemory().getPreimage( container );
			IItemReplica itemReplica = findItemInInventory();
			bot.getActionRegistry().getStoreItemInContainerAction().request( 
				bot.getPawn(),
				containerReplica,
				itemReplica,
				new ActionErrorPrinter( "Store "+itemReplica.getDisplayName() )
			);
			break;
		case DONE:
		case FAILED:
			clearSubTask();
			break;
		default:
			throw new AssertionError( "Unexpected stage: "+stage );
		}
	}
	
	@Override
	protected void clearSubTask() {
		super.clearSubTask();
		goToTask = null;
	}
	
	@Override
	public String getName() {
		return "Store in container";
	}
	
	protected IItemReplica findItemInInventory() {
		for ( IItemReplica item : bot.getPawn().readInventory() ) {
			if ( item.getGameObjectId() == itemGameObjectId ) {
				return item;
			}
		}
		
		return null;
	}
	
	protected IContainerMemorization<?> findContainerInMemory() {
		Collection<IContainerMemorization<?>> candidates = new ArrayList<IContainerMemorization<?>>();
		
		for ( StovePlateMemorization stovePlate : bot.getObservationMemory().getAllByMemorization( StovePlateMemorization.class ) ) {
			if ( !bot.getKitchen().isWithin( stovePlate.getActorLocation() ) ) {
				continue;
			}
			for ( IItemMemorization<?> item : stovePlate.readInventory() ) {
				candidates.add( (IContainerMemorization<?>) item );
			}
		}
		for ( IContainerMemorization<?> container : bot.getObservationMemory().getAllByMemorization( IContainerMemorization.class ) ) {
			if ( !bot.getKitchen().isWithin( container.getActorLocation() ) ) {
				continue;
			}
			candidates.add( container );
		}
		
		for ( IContainerMemorization<?> container : candidates ) {
			if ( container.getGameObjectId() == containerGameObjectId ) {
				return container;
			}
		}
		return null;
	}
	
	protected Location getEffectiveContainerLocation( IContainer container ) {
		Location retval = container.getActorLocation();
		if ( retval == null ) {
			retval = getEffectiveContainerLocation( (IContainer) ((IItem)container).getOwnerPossessor() );
		}
		return retval;
	}
		
	protected enum Stage {
		MOVE,
		SEARCH,
		STORE,
		DONE,
		FAILED
	}
}
