package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;

/** Look around task
 * 
 * @author Paletz
 */
public class LookAroundTask extends AbstractTask<LookAroundTask.Stage> {
	
	/** Create a look around task  
	 * 
	 * @param bot bot
	 */
	public LookAroundTask(EmohawkVilleChefBot<?> bot ) {
		super(bot, null, null );
	}
	
	@Override
	protected void updateStage() {
		stage = Stage.LOOK;
	}
	
	@Override
	protected void stageLogic() {
		bot.getMove().turnHorizontal( 30 );
	}
	
	@Override
	public String getName() {
		return "LookAround";
	}

	protected enum Stage {
		LOOK
	}
}
