package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

public class GoToTask extends AbstractTask<GoToTask.Stage> {
	
	protected Location destination;
	protected double destinationReachedDistance;
	
	public GoToTask( EmohawkVilleChefBot<?> bot, Location destination, double destinationReachedDistance ) {
		super( bot, Stage.DONE, null );
		this.destination = destination;
		this.destinationReachedDistance = destinationReachedDistance;
	}
	
	public Location getDestination() {
		return destination;
	}
	
	public double getDestinationReachedDistance() {
		return destinationReachedDistance;
	}
	
	@Override
	public void abort() {
		super.abort();
		bot.getPathExecutor().stop();
		bot.getMove().stopMovement();
	}
	
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( bot.getInfo().getDistance( destination ) <= destinationReachedDistance ) {
			stage = Stage.DONE;
			return;
		}
		
		if ( bot.getNavigation().getNearestNavPoint( bot.getInfo() ) != bot.getNavigation().getNearestNavPoint( destination ) ) {
			stage = Stage.MOVE_TO_NAVPOINT;
			return;
		} else {
			stage = Stage.MOVE_TO_LOCATION;
			return;
		}
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case DONE:
			if ( bot.getPathExecutor().isExecuting() ) {
				bot.getPathExecutor().stop();
			}
			if ( bot.getMove().isRunning() ) {
				bot.getMove().stopMovement();
			}
			break;
		case MOVE_TO_LOCATION:
			if ( bot.getPathExecutor().isExecuting() ) {
				bot.getPathExecutor().stop();
			}
			bot.getMove().moveTo( destination );
			break;
		case MOVE_TO_NAVPOINT:
		{
			IUnrealPathExecutor<ILocated> pathExecutor = bot.getPathExecutor();
			if ( pathExecutor.isTargetReached() ) {
				bot.getPathExecutor().stop();
				bot.getMove().moveTo( destination );
				return;
			}
			
			if ( pathExecutor.isStuck() ) {
				pathExecutor.stop();
				bot.getMove().moveTo( bot.getNavigation().getNearestNavPoint( bot.getInfo().getLocation() ) );
				return;
			}
			
			if ( !pathExecutor.isExecuting() ) {
				IPathFuture<NavPoint> path = bot.getFwMap().computePath( 
					bot.getInfo().getNearestNavPoint(),
					bot.getNavigation().getNearestNavPoint( destination ) 
				);
				pathExecutor.followPath( path );
			}
			
			assert( !pathExecutor.isPathUnavailable() );
			break;
		}
		default:
			throw new AssertionError();
		}
	}
	
	@Override
	public String getName() {
		return "GoTo("+destination+")";
	}
	
	protected double getNavPointProximity( Location location ) {
		return bot.getNavigation().getNearestNavPoint( location ).getLocation().getDistance( location );
	}
	
	protected enum Stage {
		MOVE_TO_NAVPOINT,
		MOVE_TO_LOCATION,
		DONE;
	}
}
