package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.ChoppingBoardMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.IChoppableItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.ChoppingBoardReplica;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IChoppingBoard;

/** Chop on a chopping board
 * 
 * @author Paletz
 */
public class ChopTask extends AbstractTask<ChopTask.Stage> {
	
	protected double searchDuration;
	protected int boardGameObjectId;
	
	protected GoToTask goToTask;
	
	/** Create a chop task
	 * 
	 * @param bot bot
	 * @param board board to chop on
	 * @param searchDuration how old board memorization is acceptable
	 */
	public ChopTask(EmohawkVilleChefBot<?> bot, IChoppingBoard board, double searchDuration ) {
		super( bot, Stage.DONE, Stage.FAILED );
		this.boardGameObjectId = board.getGameObjectId();
		this.searchDuration = searchDuration;
	}
	
	@Override
	protected void updateStage() {
		if ( isFinalStage( stage ) ) {
			return;
		}
		
		if ( bot.getActionRegistry().getChopAction().findKitchenKnife( bot.getPawn().readInventory() ) == null ) {
			stage = Stage.FAILED;
			return;
		}
		
		ChoppingBoardMemorization board = findBoardInMemory();
		if ( board == null || bot.getInfo().getTime()-board.getMemorizationEpochTime() > searchDuration ) {
			stage = Stage.FAILED;
			return;
		}
		
		{
			boolean finished = true;
			for ( IItem item : board.readInventory() ) {
				if ( item instanceof IChoppableItem ) {
					finished = false;
				}
			}
			if ( finished ) {
				stage = Stage.DONE;
				return;
			}
		}
		
		bot.getObservationMemory().setImportance( board, 16.0 );
				
		if ( bot.getInfo().getDistance( board.getActorLocation() ) < bot.getActionRegistry().getChopAction().getRange()*0.9 ) {
			if ( board.getMemorizationEpochTime() == bot.getObservationMemory().getEpochTime() ) {
				stage = Stage.CHOP;
			} else {
				stage = Stage.SEARCH;
			}
			return;
		} else {
			stage = Stage.MOVE;
			return;
		}
	}
	
	@Override
	protected void stageLogic() {
		switch ( stage ) {
		case MOVE:
			clearIncorrectSubtask( goToTask );
			
			if ( subTask == null ) {
				subTask = goToTask = new GoToTask( bot, findBoardInMemory().getActorLocation(), bot.getActionRegistry().getPickUpItemAction().getRange()*0.9 );
			}
			
			subTask.logic();
			break;
		case SEARCH:
			clearSubTask();
			bot.getMove().turnTo( findBoardInMemory().getActorLocation() );
			break;
		case CHOP:
			clearSubTask();
			
			ChoppingBoardReplica boardReplica = bot.getObservationMemory().getPreimage( findBoardInMemory() );
			bot.getActionRegistry().getChopAction().request(
				bot.getPawn(),
				boardReplica, 
				new ActionErrorPrinter( "Chop" ) 
			);
			break;
		case DONE:
		case FAILED:
			clearSubTask();
			break;
		}
	}
	
	@Override
	protected void clearSubTask() {
		super.clearSubTask();
		goToTask = null;
	}
	
	@Override
	public String getName() {
		return "Chop";
	}
	
	protected ChoppingBoardMemorization findBoardInMemory() {
		for ( ChoppingBoardMemorization board : bot.getObservationMemory().getAllByMemorization( ChoppingBoardMemorization.class ) ) {
			if ( board.getGameObjectId() == boardGameObjectId ) {
				return board;
			}
		}
		return null;
	}
	
	protected enum Stage {
		MOVE,
		SEARCH,
		CHOP,
		DONE,
		FAILED
	}
}
