package cz.cuni.amis.pogamut.emohawk.examples.chefbot.task;

import com.google.common.base.Predicate;

import cz.cuni.amis.pogamut.emohawk.agent.module.action.ActionErrorPrinter;
import cz.cuni.amis.pogamut.emohawk.examples.chefbot.EmohawkVilleChefBot;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.observationMemory.memorization.item.utensil.cookware.CookingPotMemorization;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.IStovePlate;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IBoilableIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.ingredient.IIngredient;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.IStirringSpoon;
import cz.cuni.amis.pogamut.emohawkVille.agent.module.replication.image.item.utensil.cookware.CookingPotReplica;

/** A task to boil the contents of the cooking pot on the specified stove plate.
 * 
 * @author Paletz
 */
public class BoilTask extends AbstractCookTask {

	/** Constructor
	 * 
	 * @param bot bot
	 * @param stovePlate stove plate
	 * @param searchDuration how old board memorization is acceptable
	 */
	public BoilTask(
		EmohawkVilleChefBot<?> bot,
		IStovePlate stovePlate,
		double searchDuration
	) {
		super(bot, stovePlate, searchDuration);
	}

	@Override
	protected Predicate<IItem> getToolPredicate() {
		return stirringSpoonPredicate;
	}

	@Override
	protected boolean isCooked(IIngredient ingredient) {
		return (
			! ( ingredient instanceof IBoilableIngredient ) // treat as cooked if not boilable 
			||
			((IBoilableIngredient) ingredient).getBoiledness() == 1.0
		);
	}

	@Override
	protected float getCookingRange() {
		return Math.min(
			bot.getActionRegistry().getSetStovePowerAction().getRange(),
			bot.getActionRegistry().getStirAction().getRange()
		);
	}

	@Override
	protected float getMinCookingTemperature() {
		return 80.0f;
	}

	@Override
	protected float getMaxCookingTemperature() {
		return 100.0f;
	}

	@Override
	protected void cookingLogic() {
		CookingPotReplica cookware = bot.getObservationMemory().getPreimage( findCookwareInMemory() );
		if ( !cookware.isStirrerHidden() && cookware.getStirrer() == null ) {
			bot.getActionRegistry().getStirAction().request(
				bot.getPawn(),
				cookware,
				new ActionErrorPrinter( "Stir" )
			);
		}
	}

	@Override
	protected int getTargetStovePower() {
		return 3;
	}

	@Override
	public String getName() {
		return "Boil";
	}
	
	@Override
	protected CookingPotMemorization findCookwareInMemory() {
		return (CookingPotMemorization) super.findCookwareInMemory();
	}
	
	protected static final Predicate<IItem> stirringSpoonPredicate = new Predicate<IItem>() {
		@Override
		public boolean apply( IItem item ) {
			return item instanceof IStirringSpoon;
		}
	};
}
