package cz.cuni.amis.pogamut.defcon.jason.action;

import static jason.asSyntax.ASSyntax.createString;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.jason.unitai.IJasonFleetAI;

/**
 * Returns the nuke state of the given unit.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class nukeState extends AbstractInternalAction {

    @Override
	public Object executeWorker(TransitionSystem ts, Unifier un, Term[] args)
			throws Exception {
		// // execute the internal action
		// ts.getAg().getLogger().info("executing internal action 'nukeState'");

		final IJasonFleetAI agent = (IJasonFleetAI) getAgent(ts);

		if (agent == null) {
			ts.getAg().getLogger()
					.info("'nukeState' agent fail");
			return false;
		}

		if (args.length != 2) {
			ts.getAg().getLogger()
					.info("'nukeState' args length");
			return false;
		}
		
		if (!args[0].isString()) {
			ts.getAg().getLogger()
			.info("'nukeState' is String");
			return false;			
		}
		
		StringTerm typeTerm = (StringTerm) args[0];

		UnitType type = UnitType.valueOf(typeTerm.getString());

		if (type == null) {
			ts.getAg().getLogger()
					.info("'nukeState' type is null");
			return false;
		}

		switch (type) {
			case CARRIER: {
				return un.unifies(
						args[1],
						createString("BOMBER_LAUNCH"));
			}
			case SUB: {
				return un.unifies(args[1], createString("NUKE"));
			}
		}

		return false;

    }
}
